/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class uBlock {
    public static final BlockFace[] CHEST_EXTENSION_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    public static final BlockFace[] SHOP_FACES = new BlockFace[]{BlockFace.DOWN, BlockFace.UP, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};

    public static Sign getConnectedSign(Block chestBlock) {
        return uBlock.getConnectedSign(chestBlock, null);
    }

    public static Sign getConnectedSign(Block chestBlock, Block ignoredSign) {
        Block neighbour;
        Sign sign = uBlock.findAnyNearbyShopSign(chestBlock, ignoredSign);
        if (sign == null && (neighbour = uBlock.getConnectedChest(chestBlock)) != null) {
            sign = uBlock.findAnyNearbyShopSign(neighbour, ignoredSign);
        }
        return sign;
    }

    public static Block getConnectedChest(Block chestBlock) {
        BlockData blockData = chestBlock.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chestData = (Chest)blockData;
        if (chestData.getType() != Chest.Type.SINGLE) {
            Block face;
            BlockFace chestFace = chestData.getFacing();
            if (chestFace == BlockFace.WEST) {
                chestFace = BlockFace.NORTH;
            } else if (chestFace == BlockFace.NORTH) {
                chestFace = BlockFace.EAST;
            } else if (chestFace == BlockFace.EAST) {
                chestFace = BlockFace.SOUTH;
            } else if (chestFace == BlockFace.SOUTH) {
                chestFace = BlockFace.WEST;
            }
            if (chestData.getType() == Chest.Type.RIGHT) {
                chestFace = chestFace.getOppositeFace();
            }
            if ((face = chestBlock.getRelative(chestFace)).getType() == chestBlock.getType()) {
                return face;
            }
        }
        return null;
    }

    public static Container findConnectedChest(Sign sign) {
        return uBlock.findConnectedChest(sign, false);
    }

    public static Container findConnectedChest(Sign sign, boolean upgradeItems) {
        Block chestBlock = uBlock.findConnectedChestBlock(sign, upgradeItems);
        return chestBlock == null ? null : (Container)chestBlock.getState();
    }

    public static Block findConnectedChestBlock(Sign sign) {
        return uBlock.findConnectedChestBlock(sign, false);
    }

    public static Block findConnectedChestBlock(Sign sign, boolean upgradeItems) {
        WallSign signData;
        Block faceBlock;
        Block block = sign.getBlock();
        BlockFace signFace = null;
        BlockData data = sign.getBlockData();
        if (data instanceof WallSign && BlockUtil.isChest(faceBlock = block.getRelative(signFace = (signData = (WallSign)data).getFacing().getOppositeFace()))) {
            if (upgradeItems) {
                uBlock.upgradeContainerItems(faceBlock);
            }
            return faceBlock;
        }
        for (BlockFace bf : SHOP_FACES) {
            Block faceBlock2;
            if (bf == signFace || !BlockUtil.isChest(faceBlock2 = block.getRelative(bf))) continue;
            if (upgradeItems) {
                uBlock.upgradeContainerItems(faceBlock2);
            }
            return faceBlock2;
        }
        return null;
    }

    private static void upgradeContainerItems(Block chestBlock) {
        BlockState blockState = chestBlock.getState();
        if (blockState instanceof Container) {
            ItemStack stack;
            int i;
            Container container = (Container)blockState;
            Inventory inventory = container.getInventory();
            ItemStack[] contents = inventory.getContents();
            YamlConfiguration conf = null;
            for (i = 0; i < contents.length; ++i) {
                ItemMeta meta;
                stack = contents[i];
                if (stack == null || !stack.hasItemMeta() || !(meta = stack.getItemMeta()).hasDisplayName() && !meta.hasLocalizedName() && !meta.hasLore()) continue;
                if (conf == null) {
                    conf = new YamlConfiguration();
                }
                conf.set("item" + i, (Object)stack);
            }
            if (conf != null) {
                try {
                    conf.loadFromString(conf.saveToString());
                }
                catch (InvalidConfigurationException e) {
                    throw new RuntimeException("should be impossible", e);
                }
                for (i = 0; i < contents.length; ++i) {
                    stack = conf.getItemStack("item" + i);
                    if (stack == null) continue;
                    contents[i] = stack;
                }
                inventory.setContents(contents);
            }
        }
    }

    private static Sign findAnyNearbyShopSign(Block block, Block ignoredSign) {
        for (BlockFace bf : SHOP_FACES) {
            Block attachedTo;
            Sign sign;
            Block faceBlock = block.getRelative(bf);
            if (ignoredSign != null && ignoredSign.equals((Object)faceBlock) || !BlockUtil.isSign(faceBlock) || !ChestShopSign.isChestShop(sign = (Sign)faceBlock.getState()) || (attachedTo = uBlock.findConnectedChestBlock(sign)) == null || !attachedTo.equals((Object)block)) continue;
            return sign;
        }
        return null;
    }

    public static boolean isShopChest(Block chest) {
        return uBlock.getConnectedSign(chest) != null;
    }

    public static boolean isShopChest(InventoryHolder holder) {
        Block block = uBlock.getInventoryHolderBlock(holder);
        return block != null && uBlock.isShopChest(block);
    }

    public static Block getInventoryHolderBlock(InventoryHolder holder) {
        if (holder instanceof DoubleChest) {
            return ((DoubleChest)holder).getLocation().getBlock();
        }
        if (holder instanceof BlockState) {
            return ((BlockState)holder).getBlock();
        }
        return null;
    }
}

