/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.field.types;

import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.ORMlite.field.types.BaseDataType;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseResults;
import java.sql.SQLException;

public class IntegerObjectType
extends BaseDataType {
    private static final IntegerObjectType singleTon = new IntegerObjectType();

    public static IntegerObjectType getSingleton() {
        return singleTon;
    }

    private IntegerObjectType() {
        super(SqlType.INTEGER, new Class[]{Integer.class});
    }

    protected IntegerObjectType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Integer.parseInt(defaultStr);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getInt(columnPos);
    }

    @Override
    public Object convertIdNumber(Number number) {
        return number.intValue();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isValidGeneratedType() {
        return true;
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        if (currentValue == null) {
            return 1;
        }
        return (Integer)currentValue + 1;
    }
}

