/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Signs;

import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;

public class ChestShopMetaData
implements ConfigurationSerializable {
    private UUID owner;
    private Set<UUID> accessors;
    private int quantity;
    private double buyPrice;
    private double sellPrice;
    private ItemStack itemStack;

    public ChestShopMetaData(UUID owner, int quantity, double sellPrice, double buyPrice, ItemStack itemStack) {
        this(owner, quantity, sellPrice, buyPrice, itemStack, new HashSet<UUID>());
    }

    private ChestShopMetaData(UUID owner, int quantity, double sellPrice, double buyPrice, ItemStack itemStack, Set<UUID> accessors) {
        this.owner = owner;
        this.quantity = Math.max(1, quantity);
        this.sellPrice = sellPrice;
        this.buyPrice = buyPrice;
        this.itemStack = itemStack;
        this.accessors = accessors;
    }

    public HashSet<UUID> getAccessors() {
        return new HashSet<UUID>(this.accessors);
    }

    public void addAccessor(UUID uuid) {
        this.accessors.add(uuid);
    }

    public void removeAccessor(UUID uuid) {
        this.accessors.remove(uuid);
    }

    public boolean isAccessor(UUID uuid) {
        return this.accessors.contains(uuid);
    }

    public boolean canAccess(OfflinePlayer player) {
        return this.canAccess(player.getUniqueId());
    }

    public boolean canAccess(UUID player) {
        if (this.isOwner(player)) {
            return true;
        }
        return this.isAccessor(player);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isOwner(OfflinePlayer player) {
        return this.isOwner(player.getUniqueId());
    }

    public boolean isOwner(UUID uuid) {
        return this.owner.equals(uuid);
    }

    public boolean isAdminshop() {
        return this.isOwner(NameManager.getAdminShopUUID());
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean doesBuy() {
        return this.buyPrice != -1.0;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public boolean doesSell() {
        return this.sellPrice != -1.0;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("owner", this.owner.toString());
        HashSet accessorsStrings = new HashSet();
        this.accessors.forEach(uuid -> accessorsStrings.add(uuid.toString()));
        data.put("accessors", accessorsStrings);
        data.put("amount", this.quantity);
        data.put("buyPrice", this.buyPrice);
        data.put("sellPrice", this.sellPrice);
        data.put("itemStack", this.itemStack.serialize());
        return data;
    }

    public static ChestShopMetaData deserialize(Map<String, Object> map) {
        UUID owner = UUID.fromString((String)map.get("owner"));
        int amount = (Integer)map.get("amount");
        double sellPrice = (Double)map.get("sellPrice");
        double buyPrice = (Double)map.get("buyPrice");
        ItemStack itemStack = ItemStack.deserialize((Map)((Map)map.get("itemStack")));
        HashSet accessorsString = (HashSet)map.get("accessors");
        HashSet<UUID> accessors = new HashSet<UUID>();
        accessorsString.forEach(string -> accessors.add(UUID.fromString(string)));
        return new ChestShopMetaData(owner, amount, sellPrice, buyPrice, itemStack, accessors);
    }
}

