/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Signs;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class LegacyChestShopSign {
    public static final byte NAME_LINE = 0;
    public static final byte QUANTITY_LINE = 1;
    public static final byte ITEM_LINE = 3;

    LegacyChestShopSign() {
    }

    public static boolean isAdminShop(Inventory ownerInventory) {
        return ownerInventory instanceof AdminInventory;
    }

    public static boolean isAdminShop(String owner) {
        return owner.replace(" ", "").equalsIgnoreCase(Properties.ADMIN_SHOP_NAME.replace(" ", ""));
    }

    public static ItemStack getItemStack(Sign sign) {
        return MaterialUtil.getItem(sign.getLine(3));
    }

    public static double getBuyPrice(Sign sign) {
        return PriceUtil.getBuyPrice(sign.getLine(2));
    }

    public static double getSellPrice(Sign sign) {
        return PriceUtil.getSellPrice(sign.getLine(2));
    }

    public static int getQuantity(Sign sign) {
        String line = sign.getLine(1);
        return Integer.parseInt(line.replaceAll("[^0-9]", ""));
    }

    public static boolean isAdminShop(Sign sign) {
        return LegacyChestShopSign.isAdminShop(sign.getLine(0));
    }

    public static boolean isValid(Sign sign) {
        return LegacyChestShopSign.isValid(sign.getLines());
    }

    public static boolean isValid(String[] line) {
        return ChestShopSign.isValidPreparedSign(line) && (line[2].toUpperCase().contains("B") || line[2].toUpperCase().contains("S")) && !line[0].isEmpty();
    }

    public static boolean isValid(Block sign) {
        return BlockUtil.isSign(sign) && LegacyChestShopSign.isValid((Sign)sign.getState());
    }

    public static UUID getOwnerUUID(Sign sign) {
        if (LegacyChestShopSign.isAdminShop(sign)) {
            return NameManager.getAdminShopUUID();
        }
        return NameManager.getUUIDFor(sign.getLine(0));
    }
}

