/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.ItemNamingUtils;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SignCreate
implements Listener {
    public static final String AUTOFILL_CODE = "?";
    public static final String AUTOFILL_SHULKER_CONTENT_CODE = "??";

    @EventHandler
    public static void onSignChange(SignChangeEvent event) {
        Block signBlock = event.getBlock();
        if (event.getSide() == Side.BACK) {
            if (ChestShopSign.isChestShop(signBlock)) {
                event.setCancelled(true);
            }
            return;
        }
        String[] line = StringUtil.stripColourCodes(event.getLines());
        if (!BlockUtil.isSign(signBlock)) {
            return;
        }
        if (!ChestShopSign.isValidPreparedSign(line)) {
            return;
        }
        ItemStack itemStack = SignCreate.getItemStack(event.getLine(3), (Sign)event.getBlock().getState());
        PreShopCreationEvent preEvent = new PreShopCreationEvent(event.getPlayer(), (Sign)signBlock.getState(), line, itemStack);
        ChestShop.callEvent(preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        Sign sign = (Sign)signBlock.getState();
        SignSide side = sign.getSide(event.getSide());
        for (byte i = 0; i < event.getLines().length; i = (byte)(i + 1)) {
            event.setLine((int)i, preEvent.getSignLine(i));
            side.setLine((int)i, preEvent.getSignLine(i));
        }
        ChestShopMetaData chestShopMetaData = SignCreate.createShopMetaData(event.getPlayer(), event.getLines(), itemStack);
        ShopCreatedEvent postEvent = new ShopCreatedEvent(preEvent.getPlayer(), preEvent.getSign(), uBlock.findConnectedChest(preEvent.getSign()), preEvent.getSignLines(), chestShopMetaData);
        ChestShop.callEvent(postEvent);
        SignSide signSide = sign.getSide(Side.BACK);
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            signSide.setLine(i, "");
        }
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    public static ChestShopMetaData createShopMetaData(Player creator, String[] signLines, ItemStack itemStack) {
        boolean isAdminShop;
        int quantity = Integer.parseInt(signLines[1].replaceAll("[^0-9]", ""));
        String priceLine = signLines[2];
        double sellPrice = PriceUtil.getSellPrice(priceLine);
        double buyPrice = PriceUtil.getBuyPrice(priceLine);
        String ownerLine = signLines[0];
        UUID uuidForFullName = NameManager.getUUIDFor(ownerLine);
        boolean bl = isAdminShop = NameManager.isAdminShop(uuidForFullName) && Permission.has((CommandSender)creator, Permission.ADMIN);
        if (!uuidForFullName.equals(creator.getUniqueId()) && !Permission.has((CommandSender)creator, Permission.ADMIN)) {
            return null;
        }
        if (isAdminShop) {
            return SignCreate.createAdminChestShop(quantity, sellPrice, buyPrice, itemStack);
        }
        return SignCreate.createChestShop(uuidForFullName, quantity, sellPrice, buyPrice, itemStack);
    }

    private static ChestShopMetaData createChestShop(UUID owner, int quantity, double sellPrice, double buyPrice, ItemStack itemStack) {
        return new ChestShopMetaData(owner, quantity, sellPrice, buyPrice, itemStack);
    }

    private static ChestShopMetaData createAdminChestShop(int quantity, double sellPrice, double buyPrice, ItemStack itemStack) {
        return new ChestShopMetaData(NameManager.getAdminShopUUID(), quantity, sellPrice, buyPrice, itemStack);
    }

    private static ItemStack getItemStack(String itemLine, Sign sign) {
        ChestShopMetaData chestShopMetaData;
        ItemStack itemStack;
        String oldItemDisplayName;
        Material material = MaterialUtil.getMaterial(itemLine);
        if (material != null) {
            return new ItemStack(material);
        }
        ItemStack item = null;
        if (Properties.ALLOW_AUTO_ITEM_FILL && (itemLine.equals(AUTOFILL_CODE) || itemLine.equals(AUTOFILL_SHULKER_CONTENT_CODE))) {
            item = SignCreate.autoFillItemStack(sign, itemLine);
        } else if (ChestShopSign.isChestShop(sign) && (oldItemDisplayName = ItemNamingUtils.getSignItemName(itemStack = (chestShopMetaData = ChestShopSign.getChestShopMetaData(sign)).getItemStack())).equals(itemLine)) {
            item = itemStack;
        }
        return item;
    }

    private static ItemStack autoFillItemStack(Sign sign, String itemLine) {
        Container connectedChest = uBlock.findConnectedChest(sign, true);
        if (connectedChest != null) {
            return itemLine.equals(AUTOFILL_SHULKER_CONTENT_CODE) ? SignCreate.autoFillItemStackFromShulker(connectedChest) : SignCreate.autoFillItemStackFromChest(connectedChest);
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromChest(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            return stack;
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromShulker(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            if (MaterialUtil.isEmpty(stack) || !BlockUtil.isShulkerBox(stack.getType()) || !((meta = stack.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (MaterialUtil.isEmpty(shulkerContent)) continue;
                return shulkerContent;
            }
        }
        return null;
    }
}

