/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Listeners.Economy.Plugins.VaultListener;
import com.Acrobot.ChestShop.Plugins.LightweightChestProtection;
import com.Acrobot.ChestShop.Plugins.WorldGuardBuilding;
import com.Acrobot.ChestShop.Plugins.WorldGuardFlags;
import com.Acrobot.ChestShop.Plugins.WorldGuardProtection;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;

public class Dependencies {
    public static void loadPlugins() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (String dependency : ChestShop.getDependencies()) {
            Plugin plugin = pluginManager.getPlugin(dependency);
            if (plugin == null) continue;
            Dependencies.initializePluginOnEnable(dependency, plugin);
        }
        Dependencies.loadEconomy();
    }

    private static void loadEconomy() {
        String plugin = "Vault";
        VaultListener economy = VaultListener.initializeVault();
        if (economy == null) {
            return;
        }
        ChestShop.registerListener(economy);
        ChestShop.getBukkitLogger().info(plugin + " loaded! Found an economy plugin!");
    }

    public static void initializePluginsOnLoad() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin plugin = pluginManager.getPlugin("WorldGuard");
        if (plugin != null) {
            WorldGuardFlags.ALLOW_SHOP.getName();
        }
    }

    private static void initializePluginOnEnable(String name, Plugin plugin) {
        Dependency dependency;
        try {
            dependency = Dependency.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            return;
        }
        Object listener = null;
        switch (dependency) {
            case LWC: {
                listener = new LightweightChestProtection();
                break;
            }
            case WorldGuard: {
                boolean inUse;
                WorldGuardPlugin worldGuard = (WorldGuardPlugin)plugin;
                boolean bl = inUse = Properties.WORLDGUARD_USE_PROTECTION || Properties.WORLDGUARD_INTEGRATION;
                if (!inUse) {
                    return;
                }
                if (Properties.WORLDGUARD_USE_PROTECTION) {
                    ChestShop.registerListener(new WorldGuardProtection(worldGuard));
                }
                if (!Properties.WORLDGUARD_INTEGRATION) break;
                listener = new WorldGuardBuilding(worldGuard);
            }
        }
        if (listener != null) {
            ChestShop.registerListener(listener);
        }
        PluginDescriptionFile description = plugin.getDescription();
        ChestShop.getBukkitLogger().info(description.getName() + " version " + description.getVersion() + " loaded.");
    }

    private static enum Dependency {
        LWC,
        WorldGuard;

    }
}

