/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Database;

import com.Acrobot.ChestShop.javax.persistence.Entity;
import com.Acrobot.ChestShop.javax.persistence.Id;
import com.Acrobot.ChestShop.javax.persistence.Table;
import com.google.common.base.Joiner;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class EntityParser {
    private Class<?> entity;

    public EntityParser(Class<?> table) {
        if (!table.isAnnotationPresent(Entity.class) || !table.isAnnotationPresent(Table.class)) {
            throw new AnnotationFormatError("The class hasn't got Entity or Table annotation!");
        }
        this.entity = table;
    }

    public String parseToString() {
        LinkedList<String> fields = new LinkedList<String>();
        for (Field field : this.entity.getDeclaredFields()) {
            fields.add(EntityParser.convertToSQL(field));
        }
        return Joiner.on((char)',').join(fields);
    }

    public static String convertToSQL(Field field) {
        Object sqlType = field.getName();
        Class<Comparable<Boolean>> type = field.getType();
        sqlType = type.isAssignableFrom(Boolean.TYPE) ? (String)sqlType + " BOOLEAN" : (type.isAssignableFrom(Integer.TYPE) ? (String)sqlType + " INTEGER" : (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Float.TYPE) ? (String)sqlType + " REAL" : (String)sqlType + " TEXT"));
        if (field.isAnnotationPresent(Id.class)) {
            sqlType = (String)sqlType + " PRIMARY KEY";
        }
        return sqlType;
    }
}

