/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.db;

import com.Acrobot.ChestShop.ORMlite.db.BaseDatabaseType;
import com.Acrobot.ChestShop.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.ORMlite.field.FieldConverter;
import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.ORMlite.field.types.BigDecimalStringType;
import java.util.List;

public abstract class BaseSqliteDatabaseType
extends BaseDatabaseType {
    private static final FieldConverter booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();

    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (fieldType.getSqlType() == SqlType.LONG && fieldType.isGeneratedId()) {
            sb.append("INTEGER");
        } else {
            sb.append("BIGINT");
        }
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        if (fieldType.getSqlType() != SqlType.INTEGER && fieldType.getSqlType() != SqlType.LONG) {
            throw new IllegalArgumentException("Sqlite requires that auto-increment generated-id be integer or long type");
        }
        sb.append("PRIMARY KEY AUTOINCREMENT ");
    }

    @Override
    protected boolean generatedIdSqlAtEnd() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
            case BIG_DECIMAL: {
                return BigDecimalStringType.getSingleton();
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }
}

