/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_20_R3;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public NBTTagCompound toNativeCompound(CompoundTag tag) {
        NBTTagCompound result = new NBTTagCompound();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (NBTBase)(switch (t.getType()) {
                case TagType.BYTE -> NBTTagByte.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new NBTTagByteArray(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> NBTTagDouble.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> NBTTagFloat.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> NBTTagInt.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new NBTTagIntArray(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> NBTTagLong.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> NBTTagShort.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> NBTTagString.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new NBTTagLongArray(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public NBTTagList toNativeList(ListTag tag) {
        NBTTagList result = new NBTTagList();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)NBTTagByte.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagByteArray(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)NBTTagDouble.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)NBTTagFloat.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)NBTTagInt.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagIntArray(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (Tag tag2 : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList((ListTag)tag2));
                }
            }
            case LONG: {
                for (Tag tag3 : (LongTag[])tag.getValue()) {
                    result.add((Object)NBTTagLong.a((long)((LongTag)tag3).getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)NBTTagShort.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)NBTTagString.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagLongArray(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(NBTTagCompound tag) {
        try {
            HashMap<String, Tag> result = new HashMap<String, Tag>();
            for (String name : tag.e()) {
                NBTBase b = tag.c(name);
                switch (TagType.values()[b.b()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((NBTTagByte)b).i()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((NBTTagByteArray)b).e()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((NBTTagCompound)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((NBTTagDouble)b).j()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((NBTTagFloat)b).k()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((NBTTagInt)b).g()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((NBTTagIntArray)b).g()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((NBTTagList)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((NBTTagLong)b).f()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((NBTTagShort)b).h()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((NBTTagString)b).t_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((NBTTagLongArray)b).g()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(NBTTagList tag) {
        try {
            TagType type = TagType.values()[tag.f()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            NBTTagList tagAsList = tag;
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((NBTTagByte)tagAsList.get(i)).i());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((NBTTagByteArray)tagAsList.get(i)).e());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tagAsList.get(i) == null ? new CompoundTag() : this.fromNativeCompound((NBTTagCompound)tagAsList.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((NBTTagDouble)tagAsList.get(i)).j());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((NBTTagFloat)tagAsList.get(i)).k());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((NBTTagInt)tagAsList.get(i)).g());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((NBTTagIntArray)tagAsList.get(i)).g());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((NBTTagList)tagAsList.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((NBTTagLong)tagAsList.get(i)).f());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((NBTTagShort)tagAsList.get(i)).h());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((NBTTagString)tagAsList.get(i)).t_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((NBTTagLongArray)tagAsList.get(i)).g());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        WorldServer handle = craftWorld.getHandle();
        IBlockData blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    @Override
    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag = tileEntity.o();
        return this.fromNativeCompound(tag);
    }

    @Override
    public CompoundTag readItemStack(ItemStack stack) {
        net.minecraft.world.item.ItemStack nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    @Override
    public ItemStack createItemStack(CompoundTag tag) {
        net.minecraft.world.item.ItemStack nativeStack = net.minecraft.world.item.ItemStack.a((NBTTagCompound)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nativeStack);
    }

    @Override
    public CompoundTag readEntity(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        NBTTagCompound compound = new NBTTagCompound();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    @Override
    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    @Override
    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        net.minecraft.world.entity.Entity entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    @Override
    public boolean isEntityByIdSupported() {
        return false;
    }

    @Override
    public boolean isEntityByUuidSupported() {
        return true;
    }

    @Override
    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

