/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft;

import java.text.DecimalFormat;
import org.bukkit.Location;

public final class Facing {
    public static final Facing SOUTH = new Facing(0.0f, 0.0f);
    public static final Facing WEST = new Facing(90.0f, 0.0f);
    public static final Facing NORTH = new Facing(180.0f, 0.0f);
    public static final Facing EAST = new Facing(270.0f, 0.0f);
    private final float yaw;
    private final float pitch;
    private static final DecimalFormat DEGREE_FORMAT = new DecimalFormat("###.0\u00b0");

    public Facing(double yaw, double pitch) {
        this((float)yaw, (float)pitch);
    }

    public Facing(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Facing(Location location) {
        this(location.getYaw(), location.getPitch());
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public static Facing fromLocation(Location location) {
        return new Facing(location.getYaw(), location.getPitch());
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Float.floatToIntBits(this.yaw);
        hash = 37 * hash + Float.floatToIntBits(this.pitch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Facing other = (Facing)obj;
        if (Float.floatToIntBits(this.yaw) != Float.floatToIntBits(other.yaw)) {
            return false;
        }
        return Float.floatToIntBits(this.pitch) == Float.floatToIntBits(other.pitch);
    }

    public String toString() {
        if (NORTH.equals(this)) {
            return "north";
        }
        if (EAST.equals(this)) {
            return "east";
        }
        if (SOUTH.equals(this)) {
            return "south";
        }
        if (WEST.equals(this)) {
            return "west";
        }
        return DEGREE_FORMAT.format(this.yaw) + (this.pitch < 0.0f ? " up " + DEGREE_FORMAT.format(-this.pitch) : " down " + DEGREE_FORMAT.format(this.pitch));
    }
}

