/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_19_R3;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public re toNativeCompound(CompoundTag tag) {
        re result = new re();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (rx)(switch (t.getType()) {
                case TagType.BYTE -> rc.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new rb(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> rf.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> rh.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> rj.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new ri(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> rm.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> rs.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> rv.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new rl(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public rk toNativeList(ListTag tag) {
        rk result = new rk();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)rc.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new rb(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)rf.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)rh.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)rj.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new ri(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)rm.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)rs.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)rv.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new rl(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(re tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.e()) {
                rx b = tag.c(name);
                switch (TagType.values()[b.b()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((rc)b).i()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((rb)b).e()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((re)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((rf)b).j()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((rh)b).k()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((rj)b).g()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((ri)b).g()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((rk)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((rm)b).f()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((rs)b).h()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((rv)b).f_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((rl)b).g()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(rk tag) {
        try {
            TagType type = TagType.values()[tag.f()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            rk tagAsList = tag;
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((rc)tagAsList.get(i)).i());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((rb)tagAsList.get(i)).e());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tagAsList.get(i) == null ? new CompoundTag() : this.fromNativeCompound((re)tagAsList.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((rf)tagAsList.get(i)).j());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((rh)tagAsList.get(i)).k());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((rj)tagAsList.get(i)).g());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((ri)tagAsList.get(i)).g());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((rk)tagAsList.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((rm)tagAsList.get(i)).f());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((rs)tagAsList.get(i)).h());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((rv)tagAsList.get(i)).f_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((rl)tagAsList.get(i)).g());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gt pos = new gt(block.getX(), block.getY(), block.getZ());
        cze tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        aip handle = craftWorld.getHandle();
        dbq blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gt pos = new gt(block.getX(), block.getY(), block.getZ());
        cze tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        re tag = new re();
        tag = tileEntity.m();
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(ItemStack stack) {
        cfv nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        re compound = new re();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    public ItemStack createItemStack(CompoundTag tag) {
        cfv nativeStack = cfv.a((re)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((cfv)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        bfh handle = ((CraftEntity)e).getHandle();
        re compound = new re();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        bfh entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

