/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_19_R2;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public qp toNativeCompound(CompoundTag tag) {
        qp result = new qp();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (ri)(switch (t.getType()) {
                case TagType.BYTE -> qn.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new qm(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> qq.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> qs.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> qu.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new qt(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> qx.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> rd.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> rg.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new qw(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public qv toNativeList(ListTag tag) {
        qv result = new qv();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)qn.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new qm(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)qq.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)qs.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)qu.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new qt(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)qx.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)rd.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)rg.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new qw(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(qp tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.e()) {
                ri b = tag.c(name);
                switch (TagType.values()[b.b()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((qn)b).i()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((qm)b).e()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((qp)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((qq)b).j()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((qs)b).k()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((qu)b).g()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((qt)b).g()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((qv)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((qx)b).f()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((rd)b).h()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((rg)b).f_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((qw)b).g()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(qv tag) {
        try {
            TagType type = TagType.values()[tag.f()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            qv tagAsList = tag;
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((qn)tagAsList.get(i)).i());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((qm)tagAsList.get(i)).e());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tagAsList.get(i) == null ? new CompoundTag() : this.fromNativeCompound((qp)tagAsList.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((qq)tagAsList.get(i)).j());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((qs)tagAsList.get(i)).k());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((qu)tagAsList.get(i)).g());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((qt)tagAsList.get(i)).g());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((qv)tagAsList.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((qx)tagAsList.get(i)).f());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((rd)tagAsList.get(i)).h());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((rg)tagAsList.get(i)).f_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((qw)tagAsList.get(i)).g());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gp pos = new gp(block.getX(), block.getY(), block.getZ());
        cwl tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        ahm handle = craftWorld.getHandle();
        cyt blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gp pos = new gp(block.getX(), block.getY(), block.getZ());
        cwl tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        qp tag = new qp();
        tag = tileEntity.m();
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(ItemStack stack) {
        cdt nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        qp compound = new qp();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    public ItemStack createItemStack(CompoundTag tag) {
        cdt nativeStack = cdt.a((qp)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((cdt)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        bdr handle = ((CraftEntity)e).getHandle();
        qp compound = new qp();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        bdr entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

