/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public class TagOutputStream
extends DataOutputStream {
    public TagOutputStream(OutputStream out) {
        super(out);
    }

    public void writeMCString(String string) throws IOException {
        byte[] data = string.getBytes(Tag.CHARSET);
        if (data.length > 65535) {
            throw new IOException("String too long");
        }
        this.writeShort(data.length);
        this.write(data);
    }

    public <T extends Tag> void writeTag(Map.Entry<String, T> e) throws IOException {
        String name = e.getKey();
        Tag value = (Tag)e.getValue();
        TagType type = value.getType();
        this.writeByte(type.ordinal());
        type.writeName(name, this);
        type.write(value, this);
    }
}

