/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.util.Arrays;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class IntArrayTag
extends Tag<int[]> {
    private final int[] value;

    public IntArrayTag(int[] value) {
        this.value = value;
    }

    @Override
    public int[] getValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.INT_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('\u00ab');
        int[] v = this.getValue();
        for (int i = 0; i < v.length; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(v[i]);
        }
        ret.append('\u00bb');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Arrays.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntArrayTag other = (IntArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

