/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.cyberiantiger.minecraft.Coord;

public class Cuboid {
    private final String world;
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private final int minZ;
    private final int maxZ;

    public Cuboid(Location from, Location to) {
        if (!from.getWorld().equals(to.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        this.world = from.getWorld().getName();
        if (from.getBlockX() < to.getBlockX()) {
            this.minX = from.getBlockX();
            this.maxX = to.getBlockX();
        } else {
            this.minX = to.getBlockX();
            this.maxX = from.getBlockX();
        }
        if (from.getBlockY() < to.getBlockY()) {
            this.minY = from.getBlockY();
            this.maxY = to.getBlockY();
        } else {
            this.minY = to.getBlockY();
            this.maxY = from.getBlockY();
        }
        if (from.getBlockZ() < to.getBlockZ()) {
            this.minZ = from.getBlockZ();
            this.maxZ = to.getBlockZ();
        } else {
            this.minZ = to.getBlockZ();
            this.maxZ = from.getBlockZ();
        }
    }

    public Cuboid(String world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.world = world;
        if (minX <= maxX) {
            this.minX = minX;
            this.maxX = maxX;
        } else {
            this.minX = maxX;
            this.maxX = minX;
        }
        if (minY <= maxY) {
            this.minY = minY;
            this.maxY = maxY;
        } else {
            this.minY = maxY;
            this.maxY = minY;
        }
        if (minZ <= maxZ) {
            this.minZ = minZ;
            this.maxZ = maxZ;
        } else {
            this.minZ = maxZ;
            this.maxZ = minZ;
        }
    }

    public String getWorld() {
        return this.world;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    private boolean isEmpty(World world, double x, double y, double z) {
        Block b1 = world.getBlockAt((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        Block b2 = world.getBlockAt((int)Math.floor(x), (int)Math.floor(y) + 1, (int)Math.floor(z));
        return !b1.getType().isSolid() && !b2.getType().isSolid();
    }

    public Location getCenterFloor(World world) {
        double xCenter = ((double)this.minX + 0.5 + (double)this.maxX + 0.5) / 2.0;
        double yFloor = this.minY;
        double zCenter = ((double)this.minZ + 0.5 + (double)this.maxZ + 0.5) / 2.0;
        while (!this.isEmpty(world, xCenter, yFloor, zCenter)) {
            yFloor += 1.0;
        }
        return new Location(world, xCenter, yFloor, zCenter);
    }

    public boolean contains(Location location) {
        return this.contains(Coord.fromLocation(location)) && location.getWorld().getName().equals(this.world);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.world);
        ret.append(" <");
        ret.append(this.minX);
        ret.append(" - ");
        ret.append(this.maxX);
        ret.append(", ");
        ret.append(this.minY);
        ret.append(" - ");
        ret.append(this.maxY);
        ret.append(", ");
        ret.append(this.minZ);
        ret.append(" - ");
        ret.append(this.maxZ);
        ret.append(">");
        return ret.toString();
    }

    public boolean contains(Coord coord) {
        return coord.getX() >= this.minX && coord.getX() <= this.maxX && coord.getY() >= this.minY && coord.getY() <= this.maxY && coord.getZ() >= this.minZ && coord.getZ() <= this.maxZ;
    }
}

