/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagTuple;
import org.cyberiantiger.minecraft.nbt.TagType;

public class TagInputStream
extends DataInputStream {
    public TagInputStream(InputStream in) {
        super(in);
    }

    public <T extends Tag> TagTuple<T> readTag() throws IOException {
        int tagType = this.readByte() & 0xFF;
        if (tagType >= TagType.values().length) {
            throw new IOException("Unknown tag type: " + tagType);
        }
        TagType type = TagType.values()[tagType];
        String name = type.readName(this);
        Object t = type.read(this);
        return new TagTuple(name, t);
    }

    public String readMCString() throws IOException {
        int length = this.readShort() & 0xFFFF;
        byte[] data = new byte[length];
        this.readFully(data);
        return new String(data, Tag.CHARSET);
    }
}

