/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.util.Arrays;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class ListTag
extends Tag<Tag[]> {
    private TagType listType;
    private Tag[] value;

    public ListTag(TagType listType, Tag[] value) {
        if (listType == TagType.END) {
            if (value != null) {
                throw new IllegalArgumentException("Lists of TypeType.END must have null for their value");
            }
        } else if (value.length == 0) {
            listType = TagType.END;
            value = null;
        } else {
            Class<?> c = value.getClass().getComponentType();
            if (listType.getTagClass() != value.getClass().getComponentType()) {
                throw new IllegalArgumentException("Tag class " + value.getClass().getComponentType().getName() + " is not " + listType.getTagClass());
            }
        }
        this.listType = listType;
        this.value = value;
    }

    public int size() {
        return this.value == null ? 0 : this.value.length;
    }

    public boolean isEmpty() {
        return this.value == null || this.value.length == 0;
    }

    @Override
    public Tag[] getValue() {
        return this.value;
    }

    public TagType getListType() {
        return this.listType;
    }

    @Override
    public TagType getType() {
        return TagType.LIST;
    }

    public void add(Tag t) {
        if (this.listType == TagType.END) {
            this.listType = t.getType();
            this.value = this.listType.newArray(1);
            this.value[0] = t;
        } else {
            if (t.getType() != this.listType) {
                throw new IllegalArgumentException();
            }
            Tag[] newValue = this.listType.newArray(this.value.length + 1);
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            newValue[newValue.length - 1] = t;
            this.value = newValue;
        }
    }

    public void remove(int idx) {
        if (idx < 0 || idx >= this.value.length) {
            throw new IllegalArgumentException();
        }
        if (this.value.length == 1) {
            this.listType = TagType.END;
            this.value = null;
        } else {
            Tag[] newValue = this.listType.newArray(this.value.length - 1);
            System.arraycopy(this.value, 0, newValue, 0, idx);
            System.arraycopy(this.value, idx + 1, newValue, idx, this.value.length - 1 - idx);
            this.value = newValue;
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('[');
        if (this.value != null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (i != 0) {
                    ret.append(", ");
                }
                ret.append(this.value[i].toString());
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.listType != null ? this.listType.hashCode() : 0);
        hash = 37 * hash + Arrays.deepHashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListTag other = (ListTag)obj;
        if (this.listType != other.listType) {
            return false;
        }
        return Arrays.deepEquals(this.value, other.value);
    }
}

