/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_13_R2_1;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagByte;
import net.minecraft.server.v1_13_R2.NBTTagByteArray;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NBTTagDouble;
import net.minecraft.server.v1_13_R2.NBTTagFloat;
import net.minecraft.server.v1_13_R2.NBTTagInt;
import net.minecraft.server.v1_13_R2.NBTTagIntArray;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_13_R2.NBTTagLong;
import net.minecraft.server.v1_13_R2.NBTTagLongArray;
import net.minecraft.server.v1_13_R2.NBTTagShort;
import net.minecraft.server.v1_13_R2.NBTTagString;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public static final Field COMPOUND_MAP_FIELD;
    public static final Field LIST_LIST_FIELD;

    public NBTTagCompound toNativeCompound(CompoundTag tag) {
        NBTTagCompound result = new NBTTagCompound();
        for (Map.Entry e : tag.getValue().entrySet()) {
            NBTTagCompound base;
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            switch (t.getType()) {
                case BYTE: {
                    base = new NBTTagByte(((ByteTag)t).getRawValue());
                    break;
                }
                case BYTE_ARRAY: {
                    base = new NBTTagByteArray(((ByteArrayTag)t).getValue());
                    break;
                }
                case COMPOUND: {
                    base = this.toNativeCompound((CompoundTag)t);
                    break;
                }
                case DOUBLE: {
                    base = new NBTTagDouble(((DoubleTag)t).getRawValue());
                    break;
                }
                case FLOAT: {
                    base = new NBTTagFloat(((FloatTag)t).getRawValue());
                    break;
                }
                case INT: {
                    base = new NBTTagInt(((IntTag)t).getRawValue());
                    break;
                }
                case INT_ARRAY: {
                    base = new NBTTagIntArray(((IntArrayTag)t).getValue());
                    break;
                }
                case LIST: {
                    base = this.toNativeList((ListTag)t);
                    break;
                }
                case LONG: {
                    base = new NBTTagLong(((LongTag)t).getRawValue());
                    break;
                }
                case SHORT: {
                    base = new NBTTagShort(((ShortTag)t).getRawValue());
                    break;
                }
                case STRING: {
                    base = new NBTTagString(((StringTag)t).getValue());
                    break;
                }
                case LONG_ARRAY: {
                    base = new NBTTagLongArray(((LongArrayTag)t).getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            result.set(name, (NBTBase)base);
        }
        return result;
    }

    public NBTTagList toNativeList(ListTag tag) {
        NBTTagList result = new NBTTagList();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagByte(byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagByteArray(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((NBTBase)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagDouble(doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagFloat(floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagInt(intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagIntArray(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (Tag tag2 : (ListTag[])tag.getValue()) {
                    result.add((NBTBase)this.toNativeList((ListTag)tag2));
                }
            }
            case LONG: {
                for (Tag tag3 : (LongTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagLong(((LongTag)tag3).getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagShort(shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagString(stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((NBTBase)new NBTTagLongArray(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(NBTTagCompound tag) {
        return this.fromNativeCompound(null, tag);
    }

    public CompoundTag fromNativeCompound(String parentName, NBTTagCompound tag) {
        if (COMPOUND_MAP_FIELD != null) {
            try {
                HashMap<String, Tag> result = new HashMap<String, Tag>();
                Map map = (Map)COMPOUND_MAP_FIELD.get(tag);
                for (Map.Entry e : map.entrySet()) {
                    String name = (String)e.getKey();
                    NBTBase b = (NBTBase)e.getValue();
                    switch (TagType.values()[b.getTypeId()]) {
                        case BYTE: {
                            result.put(name, new ByteTag(((NBTTagByte)b).asByte()));
                            break;
                        }
                        case BYTE_ARRAY: {
                            result.put(name, new ByteArrayTag(((NBTTagByteArray)b).c()));
                            break;
                        }
                        case COMPOUND: {
                            result.put(name, this.fromNativeCompound(name, (NBTTagCompound)b));
                            break;
                        }
                        case DOUBLE: {
                            result.put(name, new DoubleTag(((NBTTagDouble)b).asDouble()));
                            break;
                        }
                        case FLOAT: {
                            result.put(name, new FloatTag(((NBTTagFloat)b).asFloat()));
                            break;
                        }
                        case INT: {
                            result.put(name, new IntTag(((NBTTagInt)b).asInt()));
                            break;
                        }
                        case INT_ARRAY: {
                            result.put(name, new IntArrayTag(((NBTTagIntArray)b).d()));
                            break;
                        }
                        case LIST: {
                            result.put(name, this.fromNativeList(name, (NBTTagList)b));
                            break;
                        }
                        case LONG: {
                            result.put(name, new LongTag(((NBTTagLong)b).asLong()));
                            break;
                        }
                        case SHORT: {
                            result.put(name, new ShortTag(((NBTTagShort)b).asShort()));
                            break;
                        }
                        case STRING: {
                            result.put(name, new StringTag(((NBTTagString)b).asString()));
                            break;
                        }
                        case LONG_ARRAY: {
                            result.put(name, new LongArrayTag(((NBTTagLongArray)b).d()));
                        }
                    }
                }
                return new CompoundTag(result);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public ListTag fromNativeList(NBTTagList tag) {
        return this.fromNativeList(null, tag);
    }

    public ListTag fromNativeList(String parentName, NBTTagList tag) {
        try {
            TagType type = TagType.values()[tag.d()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            List list = (List)LIST_LIST_FIELD.get(tag);
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: {
                    for (int i = 0; i < list.size(); ++i) {
                        t[i] = new ByteTag(((NBTTagByte)list.get(i)).asByte());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((NBTTagByteArray)list.get(i)).c());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tag.get(i) == null ? new CompoundTag() : this.fromNativeCompound((NBTTagCompound)list.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((NBTTagDouble)list.get(i)).asDouble());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((NBTTagFloat)list.get(i)).asFloat());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((NBTTagInt)list.get(i)).asInt());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((NBTTagIntArray)list.get(i)).d());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((NBTTagList)list.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((NBTTagLong)list.get(i)).asLong());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((NBTTagShort)list.get(i)).asShort());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((NBTTagString)list.get(i)).asString());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((NBTTagLongArray)list.get(i)).d());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        TileEntity tileEntity = craftWorld.getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return;
        }
        tileEntity.save(this.toNativeCompound(tag));
        tileEntity.update();
        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        WorldServer handle = craftWorld.getHandle();
        IBlockData blockData = handle.getType(pos);
        craftWorld.getHandle().notify(new BlockPosition(block.getX(), block.getY(), block.getZ()), blockData, blockData, 3);
    }

    @Override
    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        TileEntity tileEntity = craftWorld.getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.load(tag);
        return this.fromNativeCompound(tag);
    }

    @Override
    public CompoundTag readItemStack(org.bukkit.inventory.ItemStack stack) {
        ItemStack nativeStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        nativeStack.save(compound);
        return this.fromNativeCompound(compound);
    }

    @Override
    public org.bukkit.inventory.ItemStack createItemStack(CompoundTag tag) {
        ItemStack nativeStack = ItemStack.a((NBTTagCompound)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((ItemStack)nativeStack);
    }

    @Override
    public CompoundTag readEntity(org.bukkit.entity.Entity e) {
        Entity handle = ((CraftEntity)e).getHandle();
        NBTTagCompound compound = new NBTTagCompound();
        handle.c(compound);
        return this.fromNativeCompound(compound);
    }

    @Override
    public void updateEntity(org.bukkit.entity.Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().f(this.toNativeCompound(tag));
    }

    @Override
    public org.bukkit.entity.Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        Entity entity = craftWorld.getHandle().getEntity(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    @Override
    public boolean isEntityByIdSupported() {
        return false;
    }

    @Override
    public boolean isEntityByUuidSupported() {
        return true;
    }

    @Override
    public org.bukkit.entity.Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }

    static {
        Field f = null;
        try {
            f = NBTTagCompound.class.getDeclaredField("map");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        COMPOUND_MAP_FIELD = f;
        f = null;
        try {
            f = NBTTagList.class.getDeclaredField("list");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        LIST_LIST_FIELD = f;
    }
}

