/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_17_R1;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public na toNativeCompound(CompoundTag tag) {
        na result = new na();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (ns)(switch (t.getType()) {
                case TagType.BYTE -> my.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new mx(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> nb.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> nd.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> nf.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new ne(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> ni.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> no.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> nq.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new nh(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public ng toNativeList(ListTag tag) {
        ng result = new ng();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)my.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new mx(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)nb.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)nd.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)nf.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new ne(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)ni.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)no.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)nq.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new nh(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(na tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.d()) {
                ns b = tag.c(name);
                switch (TagType.values()[b.a()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((my)b).h()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((mx)b).d()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((na)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((nb)b).i()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((nd)b).j()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((nf)b).f()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((ne)b).f()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((ng)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((ni)b).e()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((no)b).g()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((nq)b).d_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((nh)b).f()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(ng tag) {
        try {
            TagType type = TagType.values()[tag.e()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((my)tag.k(i)).h());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((mx)tag.k(i)).d());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tag.k(i) == null ? new CompoundTag() : this.fromNativeCompound((na)tag.k(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((nb)tag.k(i)).i());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((nd)tag.k(i)).j());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((nf)tag.k(i)).f());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((ne)tag.k(i)).f());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((ng)tag.k(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((ni)tag.k(i)).e());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((no)tag.k(i)).g());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((nq)tag.k(i)).d_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((nh)tag.k(i)).f());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gg pos = new gg(block.getX(), block.getY(), block.getZ());
        cip tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        abr handle = craftWorld.getHandle();
        cks blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gg pos = new gg(block.getX(), block.getY(), block.getZ());
        cip tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        na tag = new na();
        tileEntity.b(tag);
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(ItemStack stack) {
        bqp nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        na compound = new na();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    public ItemStack createItemStack(CompoundTag tag) {
        bqp nativeStack = bqp.a((na)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((bqp)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        atf handle = ((CraftEntity)e).getHandle();
        na compound = new na();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        atf entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

