/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.tree;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappedElementKind;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingFlag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingVisitor;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.tree.MappingTree;

public final class MemoryMappingTree
implements MappingTree,
MappingVisitor {
    private boolean indexByDstNames;
    private String srcNamespace;
    private List<String> dstNamespaces;
    private final List<Map.Entry<String, String>> metadata = new ArrayList<Map.Entry<String, String>>();
    private final Map<String, ClassEntry> classesBySrcName = new LinkedHashMap<String, ClassEntry>();
    private Map<String, ClassEntry>[] classesByDstNames;
    private int srcNsMap;
    private int[] dstNameMap;
    private Entry<?> currentEntry;
    private ClassEntry currentClass;
    private MethodEntry currentMethod;

    public MemoryMappingTree() {
        this(false);
    }

    public MemoryMappingTree(boolean indexByDstNames) {
        this.indexByDstNames = indexByDstNames;
    }

    public MemoryMappingTree(MappingTree src) {
        if (src instanceof MemoryMappingTree) {
            this.indexByDstNames = ((MemoryMappingTree)src).indexByDstNames;
        }
        this.setSrcNamespace(src.getSrcNamespace());
        this.setDstNamespaces(src.getDstNamespaces());
        for (Map.Entry<String, String> entry : src.getMetadata()) {
            this.addMetadata(entry.getKey(), entry.getValue());
        }
        for (MappingTree.ClassMapping classMapping : src.getClasses()) {
            this.addClass(classMapping);
        }
    }

    public void setIndexByDstNames(boolean indexByDstNames) {
        if (indexByDstNames == this.indexByDstNames) {
            return;
        }
        if (!indexByDstNames) {
            this.classesByDstNames = null;
        } else if (this.dstNamespaces != null) {
            this.initClassesByDstNames();
        }
        this.indexByDstNames = indexByDstNames;
    }

    private void initClassesByDstNames() {
        this.classesByDstNames = new Map[this.dstNamespaces.size()];
        for (int i = 0; i < this.classesByDstNames.length; ++i) {
            this.classesByDstNames[i] = new HashMap<String, ClassEntry>(this.classesBySrcName.size());
        }
        for (ClassEntry cls : this.classesBySrcName.values()) {
            for (int i = 0; i < cls.dstNames.length; ++i) {
                String dstName = cls.dstNames[i];
                if (dstName == null) continue;
                this.classesByDstNames[i].put(dstName, cls);
            }
        }
    }

    @Override
    public String getSrcNamespace() {
        return this.srcNamespace;
    }

    @Override
    public String setSrcNamespace(String namespace) {
        String ret = this.srcNamespace;
        this.srcNamespace = namespace;
        return ret;
    }

    @Override
    public List<String> getDstNamespaces() {
        return this.dstNamespaces;
    }

    @Override
    public List<String> setDstNamespaces(List<String> namespaces) {
        List<String> ret = this.dstNamespaces;
        this.dstNamespaces = namespaces;
        if (this.indexByDstNames) {
            this.initClassesByDstNames();
        }
        return ret;
    }

    @Override
    public Collection<Map.Entry<String, String>> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getMetadata(String key) {
        for (Map.Entry<String, String> entry : this.metadata) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void addMetadata(String key, String value) {
        this.metadata.add(new AbstractMap.SimpleEntry<String, String>(key, value));
    }

    @Override
    public String removeMetadata(String key) {
        Iterator<Map.Entry<String, String>> it = this.metadata.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getKey().equals(key)) continue;
            it.remove();
            return entry.getValue();
        }
        return null;
    }

    public Collection<ClassEntry> getClasses() {
        return this.classesBySrcName.values();
    }

    @Override
    public ClassEntry getClass(String srcName) {
        return this.classesBySrcName.get(srcName);
    }

    @Override
    public ClassEntry getClass(String name, int namespace) {
        if (namespace < 0 || !this.indexByDstNames) {
            return (ClassEntry)MappingTree.super.getClass(name, namespace);
        }
        return this.classesByDstNames[namespace].get(name);
    }

    @Override
    public ClassEntry addClass(MappingTree.ClassMapping cls) {
        ClassEntry entry = cls instanceof ClassEntry && cls.getTree() == this ? (ClassEntry)cls : new ClassEntry(this, cls, this.getSrcNsEquivalent(cls));
        ClassEntry ret = this.classesBySrcName.putIfAbsent(cls.getSrcName(), entry);
        if (ret != null) {
            ret.copyFrom(entry, false);
            entry = ret;
        }
        if (this.indexByDstNames) {
            for (int i = 0; i < entry.dstNames.length; ++i) {
                String dstName = entry.dstNames[i];
                if (dstName == null) continue;
                this.classesByDstNames[i].put(dstName, entry);
            }
        }
        return entry;
    }

    private int getSrcNsEquivalent(MappingTree.ElementMapping mapping) {
        int ret = mapping.getTree().getNamespaceId(this.srcNamespace);
        if (ret == -2) {
            throw new UnsupportedOperationException("can't find source namespace in referenced mapping tree");
        }
        return ret;
    }

    @Override
    public ClassEntry removeClass(String srcName) {
        ClassEntry ret = this.classesBySrcName.remove(srcName);
        if (ret != null && this.indexByDstNames) {
            for (int i = 0; i < ret.dstNames.length; ++i) {
                String dstName = ret.dstNames[i];
                if (dstName == null) continue;
                this.classesByDstNames[i].remove(dstName);
            }
        }
        return ret;
    }

    @Override
    public void accept(MappingVisitor visitor) throws IOException {
        do {
            if (visitor.visitHeader()) {
                visitor.visitNamespaces(this.srcNamespace, this.dstNamespaces);
                for (Map.Entry<String, String> entry : this.metadata) {
                    visitor.visitMetadata(entry.getKey(), entry.getValue());
                }
            }
            if (!visitor.visitContent()) continue;
            Set<MappingFlag> flags = visitor.getFlags();
            boolean supplyFieldDstDescs = flags.contains((Object)MappingFlag.NEEDS_DST_FIELD_DESC);
            boolean supplyMethodDstDescs = flags.contains((Object)MappingFlag.NEEDS_DST_METHOD_DESC);
            for (ClassEntry cls : this.classesBySrcName.values()) {
                cls.accept(visitor, supplyFieldDstDescs, supplyMethodDstDescs);
            }
        } while (!visitor.visitEnd());
    }

    @Override
    public void reset() {
        this.currentEntry = null;
        this.currentClass = null;
        this.currentMethod = null;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) {
        this.srcNsMap = -1;
        this.dstNameMap = new int[dstNamespaces.size()];
        if (this.srcNamespace != null) {
            if (!srcNamespace.equals(this.srcNamespace)) {
                this.srcNsMap = this.dstNamespaces.indexOf(srcNamespace);
                if (this.srcNsMap < 0) {
                    throw new UnsupportedOperationException("can't merge with disassociated src namespace");
                }
            }
            int newDstNamespaces = 0;
            for (int i = 0; i < this.dstNameMap.length; ++i) {
                String dstNs = dstNamespaces.get(i);
                int idx = this.dstNamespaces.indexOf(dstNs);
                if (idx < 0) {
                    if (dstNs.equals(this.srcNamespace)) {
                        throw new UnsupportedOperationException("can't merge with existing src namespace in new dst namespaces");
                    }
                    if (newDstNamespaces == 0) {
                        this.dstNamespaces = new ArrayList<String>(this.dstNamespaces);
                    }
                    idx = this.dstNamespaces.size();
                    this.dstNamespaces.add(dstNs);
                    ++newDstNamespaces;
                }
                this.dstNameMap[i] = idx;
            }
            if (newDstNamespaces > 0) {
                int newSize = this.dstNamespaces.size();
                for (ClassEntry cls : this.getClasses()) {
                    cls.resizeDstNames(newSize);
                    for (FieldEntry field : cls.getFields()) {
                        field.resizeDstNames(newSize);
                    }
                    for (MethodEntry method : cls.getMethods()) {
                        method.resizeDstNames(newSize);
                        for (MethodArgEntry arg : method.getArgs()) {
                            arg.resizeDstNames(newSize);
                        }
                        for (MethodVarEntry var : method.getVars()) {
                            var.resizeDstNames(newSize);
                        }
                    }
                }
                if (this.indexByDstNames) {
                    this.classesByDstNames = Arrays.copyOf(this.classesByDstNames, newSize);
                    for (int i = newSize - newDstNamespaces; i < this.classesByDstNames.length; ++i) {
                        this.classesByDstNames[i] = new HashMap<String, ClassEntry>(this.classesBySrcName.size());
                    }
                }
            }
        } else {
            this.srcNamespace = srcNamespace;
            this.dstNamespaces = dstNamespaces;
            for (int i = 0; i < this.dstNameMap.length; ++i) {
                this.dstNameMap[i] = i;
            }
            if (this.indexByDstNames) {
                this.initClassesByDstNames();
            }
        }
    }

    @Override
    public void visitMetadata(String key, String value) {
        this.metadata.add(new AbstractMap.SimpleEntry<String, String>(key, value));
    }

    @Override
    public boolean visitClass(String srcName) {
        this.currentMethod = null;
        ClassEntry cls = this.getClass(srcName, this.srcNsMap);
        if (cls == null) {
            if (this.srcNsMap >= 0) {
                this.currentClass = null;
                this.currentEntry = null;
                return false;
            }
            cls = new ClassEntry(this, srcName);
            this.classesBySrcName.put(srcName, cls);
        }
        this.currentEntry = this.currentClass = cls;
        return true;
    }

    @Override
    public boolean visitField(String srcName, String srcDesc) {
        if (this.currentClass == null) {
            throw new UnsupportedOperationException("Tried to visit field before owning class");
        }
        this.currentMethod = null;
        FieldEntry field = this.currentClass.getField(srcName, srcDesc, this.srcNsMap);
        if (field == null) {
            if (this.srcNsMap >= 0) {
                this.currentEntry = null;
                return false;
            }
            field = new FieldEntry(this.currentClass, srcName, srcDesc);
            field = this.currentClass.addField(field);
        } else if (srcDesc != null && field.srcDesc == null) {
            field.setSrcDesc(this.mapDesc(srcDesc, this.srcNsMap, -1));
        }
        this.currentEntry = field;
        return true;
    }

    @Override
    public boolean visitMethod(String srcName, String srcDesc) {
        if (this.currentClass == null) {
            throw new UnsupportedOperationException("Tried to visit method before owning class");
        }
        MethodEntry method = this.currentClass.getMethod(srcName, srcDesc, this.srcNsMap);
        if (method == null) {
            if (this.srcNsMap >= 0) {
                this.currentMethod = null;
                this.currentEntry = null;
                return false;
            }
            method = new MethodEntry(this.currentClass, srcName, srcDesc);
            method = this.currentClass.addMethod(method);
        } else if (srcDesc != null && (method.srcDesc == null || method.srcDesc.endsWith(")") && !srcDesc.endsWith(")"))) {
            method.setSrcDesc(this.mapDesc(srcDesc, this.srcNsMap, -1));
        }
        this.currentEntry = this.currentMethod = method;
        return true;
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, String srcName) {
        if (this.currentMethod == null) {
            throw new UnsupportedOperationException("Tried to visit method argument before owning method");
        }
        MethodArgEntry arg = this.currentMethod.getArg(argPosition, lvIndex, srcName);
        if (arg == null) {
            arg = new MethodArgEntry(this.currentMethod, argPosition, lvIndex, srcName);
            arg = this.currentMethod.addArg(arg);
        } else {
            if (argPosition >= 0 && arg.argPosition < 0) {
                arg.setArgPosition(argPosition);
            }
            if (lvIndex >= 0 && arg.lvIndex < 0) {
                arg.setLvIndex(lvIndex);
            }
            if (srcName != null) {
                assert (!srcName.isEmpty());
                arg.setSrcName(srcName);
            }
        }
        this.currentEntry = arg;
        return true;
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
        if (this.currentMethod == null) {
            throw new UnsupportedOperationException("Tried to visit method variable before owning method");
        }
        MethodVarEntry var = this.currentMethod.getVar(lvtRowIndex, lvIndex, startOpIdx, srcName);
        if (var == null) {
            var = new MethodVarEntry(this.currentMethod, lvtRowIndex, lvIndex, startOpIdx, srcName);
            var = this.currentMethod.addVar(var);
        } else {
            if (lvtRowIndex >= 0 && var.lvtRowIndex < 0) {
                var.setLvtRowIndex(lvtRowIndex);
            }
            if (lvIndex >= 0 && startOpIdx >= 0 && (var.lvIndex < 0 || var.startOpIdx < 0)) {
                var.setLvIndex(lvIndex, startOpIdx);
            }
            if (srcName != null) {
                assert (!srcName.isEmpty());
                var.setSrcName(srcName);
            }
        }
        this.currentEntry = var;
        return true;
    }

    @Override
    public boolean visitEnd() {
        this.currentEntry = null;
        this.currentClass = null;
        this.currentMethod = null;
        return true;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) {
        namespace = this.dstNameMap[namespace];
        if (this.currentEntry == null) {
            throw new UnsupportedOperationException("Tried to visit mapped name before owner");
        }
        this.currentEntry.setDstName(name, namespace);
        if (this.indexByDstNames && targetKind == MappedElementKind.CLASS) {
            this.classesByDstNames[namespace].put(name, this.currentClass);
        }
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) {
        Entry entry;
        switch (targetKind) {
            case CLASS: {
                entry = this.currentClass;
                break;
            }
            case METHOD: {
                entry = this.currentMethod;
                break;
            }
            default: {
                entry = this.currentEntry;
            }
        }
        if (entry == null) {
            throw new UnsupportedOperationException("Tried to visit comment before owning target");
        }
        entry.setComment(comment);
    }

    static final class ClassEntry
    extends Entry<ClassEntry>
    implements MappingTree.ClassMapping {
        private static final byte FLAG_HAS_ANY_FIELD_DESC = 1;
        private static final byte FLAG_MISSES_ANY_FIELD_DESC = 2;
        private static final byte FLAG_HAS_ANY_METHOD_DESC = 4;
        private static final byte FLAG_MISSES_ANY_METHOD_DESC = 8;
        protected final MemoryMappingTree tree;
        private Map<MemberKey, FieldEntry> fields = null;
        private Map<MemberKey, MethodEntry> methods = null;
        private byte flags;

        ClassEntry(MemoryMappingTree tree, String srcName) {
            super(tree, srcName);
            this.tree = tree;
        }

        ClassEntry(MemoryMappingTree tree, MappingTree.ClassMapping src, int srcNsEquivalent) {
            super(tree, src, srcNsEquivalent);
            this.tree = tree;
            for (MappingTree.FieldMapping fieldMapping : src.getFields()) {
                this.addField(fieldMapping);
            }
            for (MappingTree.MethodMapping methodMapping : src.getMethods()) {
                this.addMethod(methodMapping);
            }
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.CLASS;
        }

        @Override
        public MemoryMappingTree getTree() {
            return this.tree;
        }

        @Override
        public void setDstName(String name, int namespace) {
            String oldName;
            if (this.tree.indexByDstNames && !Objects.equals(name, oldName = this.dstNames[namespace])) {
                Map map = this.tree.classesByDstNames[namespace];
                if (oldName != null) {
                    map.remove(oldName);
                }
                if (name != null) {
                    map.put(name, this);
                } else {
                    map.remove(oldName);
                }
            }
            super.setDstName(name, namespace);
        }

        public Collection<FieldEntry> getFields() {
            if (this.fields == null) {
                return Collections.emptyList();
            }
            return this.fields.values();
        }

        @Override
        public FieldEntry getField(String srcName, String srcDesc) {
            return ClassEntry.getMember(srcName, srcDesc, this.fields, this.flags, 1, 2);
        }

        @Override
        public FieldEntry getField(String name, String desc, int namespace) {
            return (FieldEntry)MappingTree.ClassMapping.super.getField(name, desc, namespace);
        }

        @Override
        public FieldEntry addField(MappingTree.FieldMapping field) {
            FieldEntry entry;
            FieldEntry fieldEntry = entry = field instanceof FieldEntry && field.getOwner() == this ? (FieldEntry)field : new FieldEntry(this, field, this.tree.getSrcNsEquivalent(field));
            if (this.fields == null) {
                this.fields = new LinkedHashMap<MemberKey, FieldEntry>();
            }
            return this.addMember(entry, this.fields, 1, 2);
        }

        @Override
        public FieldEntry removeField(String srcName, String srcDesc) {
            FieldEntry ret = this.getField(srcName, srcDesc);
            if (ret != null) {
                this.fields.remove(ret.key);
            }
            return ret;
        }

        public Collection<MethodEntry> getMethods() {
            if (this.methods == null) {
                return Collections.emptyList();
            }
            return this.methods.values();
        }

        @Override
        public MethodEntry getMethod(String srcName, String srcDesc) {
            return ClassEntry.getMember(srcName, srcDesc, this.methods, this.flags, 4, 8);
        }

        @Override
        public MethodEntry getMethod(String name, String desc, int namespace) {
            return (MethodEntry)MappingTree.ClassMapping.super.getMethod(name, desc, namespace);
        }

        @Override
        public MethodEntry addMethod(MappingTree.MethodMapping method) {
            MethodEntry entry;
            MethodEntry methodEntry = entry = method instanceof MethodEntry && method.getOwner() == this ? (MethodEntry)method : new MethodEntry(this, method, this.tree.getSrcNsEquivalent(method));
            if (this.methods == null) {
                this.methods = new LinkedHashMap<MemberKey, MethodEntry>();
            }
            return this.addMember(entry, this.methods, 4, 8);
        }

        @Override
        public MethodEntry removeMethod(String srcName, String srcDesc) {
            MethodEntry ret = this.getMethod(srcName, srcDesc);
            if (ret != null) {
                this.methods.remove(ret.key);
            }
            return ret;
        }

        private static <T extends MemberEntry<T>> T getMember(String srcName, String srcDesc, Map<MemberKey, T> map, int flags, int flagHasAny, int flagMissesAny) {
            block13: {
                MemberEntry ret;
                boolean missedAnyDesc;
                boolean hasAnyDesc;
                block14: {
                    block12: {
                        Object ret2;
                        if (map == null) {
                            return null;
                        }
                        hasAnyDesc = (flags & flagHasAny) != 0;
                        boolean bl = missedAnyDesc = (flags & flagMissesAny) != 0;
                        if (srcDesc != null) break block12;
                        if (missedAnyDesc && (ret2 = (MemberEntry)map.get(new MemberKey(srcName, null))) != null) {
                            return (T)ret2;
                        }
                        if (!hasAnyDesc) break block13;
                        for (MemberEntry entry : map.values()) {
                            if (!entry.srcName.equals(srcName)) continue;
                            return (T)entry;
                        }
                        break block13;
                    }
                    if (!srcDesc.endsWith(")")) break block14;
                    if (missedAnyDesc) {
                        Object ret3 = (MemberEntry)map.get(new MemberKey(srcName, srcDesc));
                        if (ret3 != null) {
                            return (T)ret3;
                        }
                        ret3 = (MemberEntry)map.get(new MemberKey(srcName, null));
                        if (ret3 != null) {
                            return (T)ret3;
                        }
                    }
                    if (!hasAnyDesc) break block13;
                    for (MemberEntry entry : map.values()) {
                        if (!entry.srcName.equals(srcName) || !entry.srcDesc.startsWith(srcDesc)) continue;
                        return (T)entry;
                    }
                    break block13;
                }
                if (hasAnyDesc && (ret = (MemberEntry)map.get(new MemberKey(srcName, srcDesc))) != null) {
                    return (T)ret;
                }
                if (missedAnyDesc) {
                    ret = (MemberEntry)map.get(new MemberKey(srcName, null));
                    if (ret != null) {
                        return (T)ret;
                    }
                    if (srcDesc.indexOf(41) >= 0) {
                        for (MemberEntry entry : map.values()) {
                            if (!entry.srcName.equals(srcName) || !srcDesc.startsWith(entry.srcDesc)) continue;
                            return (T)entry;
                        }
                    }
                }
            }
            return null;
        }

        private <T extends MemberEntry<T>> T addMember(T entry, Map<MemberKey, T> map, int flagHasAny, int flagMissesAny) {
            MemberEntry ret = (MemberEntry)map.putIfAbsent(entry.key, entry);
            if (ret != null) {
                ret.copyFrom(entry, false);
                return (T)ret;
            }
            if (entry.srcDesc != null && !entry.srcDesc.endsWith(")")) {
                this.flags = (byte)(this.flags | flagHasAny);
                if ((this.flags & flagMissesAny) != 0 && (ret = (MemberEntry)map.remove(new MemberKey(this.srcName, null))) != null) {
                    ret.key = entry.key;
                    ret.srcDesc = entry.srcDesc;
                    map.put(ret.key, ret);
                    ret.copyFrom(entry, false);
                    entry = ret;
                }
                return entry;
            }
            if ((this.flags & flagHasAny) != 0) {
                for (MemberEntry prevEntry : map.values()) {
                    if (prevEntry == entry || !prevEntry.srcName.equals(this.srcName) || entry.srcDesc != null && !prevEntry.srcDesc.startsWith(entry.srcDesc)) continue;
                    map.remove(entry.key);
                    prevEntry.copyFrom(entry, false);
                    return (T)prevEntry;
                }
            }
            this.flags = (byte)(this.flags | flagMissesAny);
            return entry;
        }

        void accept(MappingVisitor visitor, boolean supplyFieldDstDescs, boolean supplyMethodDstDescs) throws IOException {
            if (visitor.visitClass(this.srcName) && this.acceptElement(visitor, null)) {
                if (this.fields != null) {
                    for (FieldEntry field : this.fields.values()) {
                        field.accept(visitor, supplyFieldDstDescs);
                    }
                }
                if (this.methods != null) {
                    for (MethodEntry method : this.methods.values()) {
                        method.accept(visitor, supplyMethodDstDescs);
                    }
                }
            }
        }

        @Override
        protected void copyFrom(ClassEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.fields != null) {
                for (FieldEntry oField : o.fields.values()) {
                    FieldEntry field = this.getField(oField.srcName, oField.srcDesc);
                    if (field == null) {
                        this.addField(oField);
                        continue;
                    }
                    if (oField.srcDesc != null && field.srcDesc == null) {
                        this.fields.remove(field.key);
                        field.key = oField.key;
                        field.srcDesc = oField.srcDesc;
                        this.fields.put(field.key, field);
                        this.flags = (byte)(this.flags | 1);
                    }
                    field.copyFrom(oField, replace);
                }
            }
            if (o.methods != null) {
                for (MethodEntry oMethod : o.methods.values()) {
                    MethodEntry method = this.getMethod(oMethod.srcName, oMethod.srcDesc);
                    if (method == null) {
                        this.addMethod(oMethod);
                        continue;
                    }
                    if (oMethod.srcDesc != null && method.srcDesc == null) {
                        this.methods.remove(method.key);
                        method.key = oMethod.key;
                        method.srcDesc = oMethod.srcDesc;
                        this.methods.put(method.key, method);
                        this.flags = (byte)(this.flags | 4);
                    }
                    method.copyFrom(oMethod, replace);
                }
            }
        }

        public String toString() {
            return this.srcName;
        }
    }

    static abstract class Entry<T extends Entry<T>>
    implements MappingTree.ElementMapping {
        protected String srcName;
        protected String[] dstNames;
        protected String comment;

        protected Entry(MemoryMappingTree tree, String srcName) {
            this.srcName = srcName;
            this.dstNames = new String[tree.dstNamespaces.size()];
        }

        protected Entry(MemoryMappingTree tree, MappingTree.ElementMapping src, int srcNsEquivalent) {
            this(tree, src.getName(srcNsEquivalent));
            for (int i = 0; i < this.dstNames.length; ++i) {
                int dstNsEquivalent = src.getTree().getNamespaceId((String)tree.dstNamespaces.get(i));
                if (dstNsEquivalent == -2) continue;
                this.setDstName(src.getDstName(dstNsEquivalent), i);
            }
            this.setComment(src.getComment());
        }

        public abstract MappedElementKind getKind();

        @Override
        public final String getSrcName() {
            return this.srcName;
        }

        @Override
        public final String getDstName(int namespace) {
            return this.dstNames[namespace];
        }

        @Override
        public void setDstName(String name, int namespace) {
            this.dstNames[namespace] = name;
        }

        void resizeDstNames(int newSize) {
            this.dstNames = Arrays.copyOf(this.dstNames, newSize);
        }

        @Override
        public final String getComment() {
            return this.comment;
        }

        @Override
        public final void setComment(String comment) {
            this.comment = comment;
        }

        protected final boolean acceptElement(MappingVisitor visitor, String[] dstDescs) throws IOException {
            int i;
            MappedElementKind kind = this.getKind();
            for (i = 0; i < this.dstNames.length; ++i) {
                String dstName = this.dstNames[i];
                if (dstName == null) continue;
                visitor.visitDstName(kind, i, dstName);
            }
            if (dstDescs != null) {
                for (i = 0; i < dstDescs.length; ++i) {
                    String dstDesc = dstDescs[i];
                    if (dstDesc == null) continue;
                    visitor.visitDstDesc(kind, i, dstDesc);
                }
            }
            if (!visitor.visitElementContent(kind)) {
                return false;
            }
            if (this.comment != null) {
                visitor.visitComment(kind, this.comment);
            }
            return true;
        }

        protected void copyFrom(T o, boolean replace) {
            for (int i = 0; i < this.dstNames.length; ++i) {
                if (((Entry)o).dstNames[i] == null || !replace && this.dstNames[i] != null) continue;
                this.dstNames[i] = ((Entry)o).dstNames[i];
            }
            if (((Entry)o).comment != null && (replace || this.comment == null)) {
                this.comment = ((Entry)o).comment;
            }
        }
    }

    static final class MethodEntry
    extends MemberEntry<MethodEntry>
    implements MappingTree.MethodMapping {
        private List<MethodArgEntry> args = null;
        private List<MethodVarEntry> vars = null;

        MethodEntry(ClassEntry owner, String srcName, String srcDesc) {
            super(owner, srcName, srcDesc);
        }

        MethodEntry(ClassEntry owner, MappingTree.MethodMapping src, int srcNsEquivalent) {
            super(owner, src, srcNsEquivalent);
            for (MappingTree.MethodArgMapping methodArgMapping : src.getArgs()) {
                this.addArg(methodArgMapping);
            }
            for (MappingTree.MethodVarMapping methodVarMapping : src.getVars()) {
                this.addVar(methodVarMapping);
            }
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD;
        }

        @Override
        public void setSrcDesc(String desc) {
            if (Objects.equals(desc, this.srcDesc)) {
                return;
            }
            MemberKey newKey = new MemberKey(this.srcName, desc);
            if (this.owner.methods.containsKey(newKey)) {
                throw new IllegalArgumentException("conflicting name+desc after changing desc to " + desc + " for " + this);
            }
            this.owner.methods.remove(this.key);
            this.srcDesc = desc;
            this.key = newKey;
            this.owner.methods.put(newKey, this);
            if (desc != null && !desc.endsWith(")")) {
                this.owner.flags = (byte)(this.owner.flags | 4);
            } else {
                this.owner.flags = (byte)(this.owner.flags | 8);
            }
        }

        public Collection<MethodArgEntry> getArgs() {
            if (this.args == null) {
                return Collections.emptyList();
            }
            return this.args;
        }

        @Override
        public MethodArgEntry getArg(int argPosition, int lvIndex, String srcName) {
            if (this.args == null) {
                return null;
            }
            if (argPosition >= 0 || lvIndex >= 0) {
                for (MethodArgEntry entry : this.args) {
                    if ((argPosition < 0 || entry.argPosition != argPosition) && (lvIndex < 0 || entry.lvIndex != lvIndex)) continue;
                    return entry;
                }
            }
            if (srcName != null) {
                for (MethodArgEntry entry : this.args) {
                    if (!srcName.equals(entry.srcName) || argPosition >= 0 && entry.argPosition >= 0 || lvIndex >= 0 && entry.lvIndex >= 0) continue;
                    return entry;
                }
            }
            return null;
        }

        @Override
        public MethodArgEntry addArg(MappingTree.MethodArgMapping arg) {
            MethodArgEntry entry = arg instanceof MethodArgEntry && arg.getMethod() == this ? (MethodArgEntry)arg : new MethodArgEntry(this, arg, this.owner.tree.getSrcNsEquivalent(arg));
            MethodArgEntry prev = this.getArg(arg.getArgPosition(), arg.getLvIndex(), arg.getSrcName());
            if (prev == null) {
                if (this.args == null) {
                    this.args = new ArrayList<MethodArgEntry>();
                }
                this.args.add(entry);
            } else {
                this.updateArg(prev, entry, false);
            }
            return entry;
        }

        private void updateArg(MethodArgEntry existing, MethodArgEntry toAdd, boolean replace) {
            if (toAdd.argPosition >= 0 && existing.argPosition < 0) {
                existing.setArgPosition(toAdd.argPosition);
            }
            if (toAdd.lvIndex >= 0 && existing.lvIndex < 0) {
                existing.setLvIndex(toAdd.getLvIndex());
            }
            existing.copyFrom(toAdd, replace);
        }

        @Override
        public MethodArgEntry removeArg(int argPosition, int lvIndex, String srcName) {
            MethodArgEntry ret = this.getArg(argPosition, lvIndex, srcName);
            if (ret != null) {
                this.args.remove(ret);
            }
            return ret;
        }

        public Collection<MethodVarEntry> getVars() {
            if (this.vars == null) {
                return Collections.emptyList();
            }
            return this.vars;
        }

        @Override
        public MethodVarEntry getVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
            boolean hasMissing;
            if (this.vars == null) {
                return null;
            }
            if (lvtRowIndex >= 0) {
                hasMissing = false;
                for (MethodVarEntry entry : this.vars) {
                    if (entry.lvtRowIndex == lvtRowIndex) {
                        return entry;
                    }
                    if (entry.lvtRowIndex >= 0) continue;
                    hasMissing = true;
                }
                if (!hasMissing) {
                    return null;
                }
            }
            if (lvIndex >= 0) {
                hasMissing = false;
                MethodVarEntry bestMatch = null;
                for (MethodVarEntry entry : this.vars) {
                    if (entry.lvIndex != lvIndex) {
                        if (entry.lvIndex >= 0) continue;
                        hasMissing = true;
                        continue;
                    }
                    if (bestMatch == null) {
                        bestMatch = entry;
                        continue;
                    }
                    int startOpDeltaImprovement = startOpIdx < 0 || bestMatch.startOpIdx < 0 && entry.startOpIdx < 0 ? 0 : (bestMatch.startOpIdx < 0 ? 1 : (entry.startOpIdx < 0 ? -1 : Math.abs(bestMatch.startOpIdx - startOpIdx) - Math.abs(entry.startOpIdx - startOpIdx)));
                    if (startOpDeltaImprovement <= 0 && (startOpDeltaImprovement != 0 || srcName == null || !srcName.equals(entry.srcName) || srcName.equals(bestMatch.srcName))) continue;
                    bestMatch = entry;
                }
                if (!hasMissing || bestMatch != null) {
                    return bestMatch;
                }
            }
            if (srcName != null) {
                for (MethodVarEntry entry : this.vars) {
                    if (!srcName.equals(entry.srcName) || lvtRowIndex >= 0 && entry.lvtRowIndex >= 0 || lvIndex >= 0 && entry.lvIndex >= 0) continue;
                    return entry;
                }
            }
            return null;
        }

        @Override
        public MethodVarEntry addVar(MappingTree.MethodVarMapping var) {
            MethodVarEntry entry = var instanceof MethodVarEntry && var.getMethod() == this ? (MethodVarEntry)var : new MethodVarEntry(this, var, this.owner.tree.getSrcNsEquivalent(var));
            MethodVarEntry prev = this.getVar(var.getLvtRowIndex(), var.getLvIndex(), var.getStartOpIdx(), var.getSrcName());
            if (prev == null) {
                if (this.vars == null) {
                    this.vars = new ArrayList<MethodVarEntry>();
                }
                this.vars.add(entry);
            } else {
                this.updateVar(prev, entry, false);
            }
            return entry;
        }

        private void updateVar(MethodVarEntry existing, MethodVarEntry toAdd, boolean replace) {
            if (toAdd.lvtRowIndex >= 0 && existing.lvtRowIndex < 0) {
                existing.setLvtRowIndex(toAdd.lvtRowIndex);
            }
            if (toAdd.lvIndex >= 0 && toAdd.startOpIdx >= 0 && (existing.lvIndex < 0 || existing.startOpIdx < 0)) {
                existing.setLvIndex(toAdd.lvIndex, toAdd.startOpIdx);
            }
            existing.copyFrom(toAdd, replace);
        }

        @Override
        public MethodVarEntry removeVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
            MethodVarEntry ret = this.getVar(lvtRowIndex, lvIndex, startOpIdx, srcName);
            if (ret != null) {
                this.vars.remove(ret);
            }
            return ret;
        }

        void accept(MappingVisitor visitor, boolean supplyDstDescs) throws IOException {
            if (visitor.visitMethod(this.srcName, this.srcDesc) && this.acceptMember(visitor, supplyDstDescs)) {
                if (this.args != null) {
                    for (MethodArgEntry arg : this.args) {
                        arg.accept(visitor);
                    }
                }
                if (this.vars != null) {
                    for (MethodVarEntry var : this.vars) {
                        var.accept(visitor);
                    }
                }
            }
        }

        @Override
        protected void copyFrom(MethodEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.args != null) {
                for (MethodArgEntry oArg : o.args) {
                    MethodArgEntry arg = this.getArg(oArg.argPosition, oArg.lvIndex, oArg.srcName);
                    if (arg == null) {
                        this.addArg(oArg);
                        continue;
                    }
                    this.updateArg(arg, oArg, replace);
                }
            }
            if (o.vars != null) {
                for (MethodVarEntry oVar : o.vars) {
                    MethodVarEntry var = this.getVar(oVar.lvtRowIndex, oVar.lvIndex, oVar.startOpIdx, oVar.srcName);
                    if (var == null) {
                        this.addVar(oVar);
                        continue;
                    }
                    this.updateVar(var, oVar, replace);
                }
            }
        }

        public String toString() {
            return String.format("%s%s", this.srcName, this.srcDesc);
        }
    }

    static final class FieldEntry
    extends MemberEntry<FieldEntry>
    implements MappingTree.FieldMapping {
        FieldEntry(ClassEntry owner, String srcName, String srcDesc) {
            super(owner, srcName, srcDesc);
        }

        FieldEntry(ClassEntry owner, MappingTree.FieldMapping src, int srcNsEquivalent) {
            super(owner, src, srcNsEquivalent);
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.FIELD;
        }

        @Override
        public void setSrcDesc(String desc) {
            if (Objects.equals(desc, this.srcDesc)) {
                return;
            }
            MemberKey newKey = new MemberKey(this.srcName, desc);
            if (this.owner.fields.containsKey(newKey)) {
                throw new IllegalArgumentException("conflicting name+desc after changing desc to " + desc + " for " + this);
            }
            this.owner.fields.remove(this.key);
            this.srcDesc = desc;
            this.key = newKey;
            this.owner.fields.put(newKey, this);
            if (desc != null) {
                this.owner.flags = (byte)(this.owner.flags | 1);
            } else {
                this.owner.flags = (byte)(this.owner.flags | 2);
            }
        }

        void accept(MappingVisitor visitor, boolean supplyDstDescs) throws IOException {
            if (visitor.visitField(this.srcName, this.srcDesc)) {
                this.acceptMember(visitor, supplyDstDescs);
            }
        }

        public String toString() {
            return String.format("%s;;%s", this.srcName, this.srcDesc);
        }
    }

    static final class MethodArgEntry
    extends Entry<MethodArgEntry>
    implements MappingTree.MethodArgMapping {
        private final MethodEntry method;
        private int argPosition;
        private int lvIndex;

        MethodArgEntry(MethodEntry method, int argPosition, int lvIndex, String srcName) {
            super(method.owner.tree, srcName);
            this.method = method;
            this.argPosition = argPosition;
            this.lvIndex = lvIndex;
        }

        MethodArgEntry(MethodEntry method, MappingTree.MethodArgMapping src, int srcNsEquivalent) {
            super(method.owner.tree, src, srcNsEquivalent);
            this.method = method;
            this.argPosition = src.getArgPosition();
            this.lvIndex = src.getLvIndex();
        }

        @Override
        public MappingTree getTree() {
            return this.method.owner.tree;
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD_ARG;
        }

        @Override
        public MethodEntry getMethod() {
            return this.method;
        }

        @Override
        public int getArgPosition() {
            return this.argPosition;
        }

        @Override
        public void setArgPosition(int position) {
            this.argPosition = position;
        }

        @Override
        public int getLvIndex() {
            return this.lvIndex;
        }

        @Override
        public void setLvIndex(int index) {
            this.lvIndex = index;
        }

        public void setSrcName(String name) {
            this.srcName = name;
        }

        void accept(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethodArg(this.argPosition, this.lvIndex, this.srcName)) {
                this.acceptElement(visitor, null);
            }
        }

        @Override
        protected void copyFrom(MethodArgEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.srcName != null && (replace || this.srcName == null)) {
                this.srcName = o.srcName;
            }
        }

        public String toString() {
            return String.format("%d/%d:%s", this.argPosition, this.lvIndex, this.srcName);
        }
    }

    static final class MethodVarEntry
    extends Entry<MethodVarEntry>
    implements MappingTree.MethodVarMapping {
        private final MethodEntry method;
        private int lvtRowIndex;
        private int lvIndex;
        private int startOpIdx;

        MethodVarEntry(MethodEntry method, int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
            super(method.owner.tree, srcName);
            this.method = method;
            this.lvtRowIndex = lvtRowIndex;
            this.lvIndex = lvIndex;
            this.startOpIdx = startOpIdx;
        }

        MethodVarEntry(MethodEntry method, MappingTree.MethodVarMapping src, int srcNs) {
            super(method.owner.tree, src, srcNs);
            this.method = method;
            this.lvtRowIndex = src.getLvtRowIndex();
            this.lvIndex = src.getLvIndex();
            this.startOpIdx = src.getStartOpIdx();
        }

        @Override
        public MappingTree getTree() {
            return this.method.owner.tree;
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD_VAR;
        }

        @Override
        public MethodEntry getMethod() {
            return this.method;
        }

        @Override
        public int getLvtRowIndex() {
            return this.lvtRowIndex;
        }

        @Override
        public void setLvtRowIndex(int index) {
            this.lvtRowIndex = index;
        }

        @Override
        public int getLvIndex() {
            return this.lvIndex;
        }

        @Override
        public int getStartOpIdx() {
            return this.startOpIdx;
        }

        @Override
        public void setLvIndex(int lvIndex, int startOpIdx) {
            this.lvIndex = lvIndex;
            this.startOpIdx = startOpIdx;
        }

        public void setSrcName(String name) {
            this.srcName = name;
        }

        void accept(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethodVar(this.lvtRowIndex, this.lvIndex, this.startOpIdx, this.srcName)) {
                this.acceptElement(visitor, null);
            }
        }

        @Override
        protected void copyFrom(MethodVarEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.srcName != null && (replace || this.srcName == null)) {
                this.srcName = o.srcName;
            }
        }

        public String toString() {
            return String.format("%d/%d@%d:%s", this.lvtRowIndex, this.lvIndex, this.startOpIdx, this.srcName);
        }
    }

    static final class MemberKey {
        private final String name;
        private final String desc;
        private final int hash;

        MemberKey(String name, String desc) {
            this.name = name;
            this.desc = desc;
            this.hash = desc == null ? name.hashCode() : name.hashCode() * 257 + desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != MemberKey.class) {
                return false;
            }
            MemberKey o = (MemberKey)obj;
            return this.name.equals(o.name) && Objects.equals(this.desc, o.desc);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return String.format("%s.%s", this.name, this.desc);
        }
    }

    static abstract class MemberEntry<T extends MemberEntry<T>>
    extends Entry<T>
    implements MappingTree.MemberMapping {
        protected final ClassEntry owner;
        protected String srcDesc;
        MemberKey key;

        protected MemberEntry(ClassEntry owner, String srcName, String srcDesc) {
            super(owner.tree, srcName);
            this.owner = owner;
            this.srcDesc = srcDesc;
            this.key = new MemberKey(srcName, srcDesc);
        }

        protected MemberEntry(ClassEntry owner, MappingTree.MemberMapping src, int srcNsEquivalent) {
            super(owner.tree, src, srcNsEquivalent);
            this.owner = owner;
            this.srcDesc = src.getDesc(srcNsEquivalent);
            this.key = new MemberKey(this.srcName, this.srcDesc);
        }

        @Override
        public MappingTree getTree() {
            return this.owner.tree;
        }

        @Override
        public final ClassEntry getOwner() {
            return this.owner;
        }

        @Override
        public final String getSrcDesc() {
            return this.srcDesc;
        }

        protected final boolean acceptMember(MappingVisitor visitor, boolean supplyDstDescs) throws IOException {
            String[] dstDescs;
            if (!supplyDstDescs || this.srcDesc == null) {
                dstDescs = null;
            } else {
                MemoryMappingTree tree = this.owner.tree;
                dstDescs = new String[tree.getDstNamespaces().size()];
                for (int i = 0; i < dstDescs.length; ++i) {
                    dstDescs[i] = tree.mapDesc(this.srcDesc, i);
                }
            }
            return this.acceptElement(visitor, dstDescs);
        }
    }
}

