/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.items;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyberiantiger.minecraft.itemcontrol.Main;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.nbt.ListTag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.nbt.TagType;

public class ItemType {
    private static final Set<Short> DEFAULT_DAMAGE = Collections.singleton((short)0);
    private Set<Short> damage = DEFAULT_DAMAGE;
    private List<String> tags = Collections.emptyList();
    private transient Set<CompoundTag> parsedTags = null;

    public Set<Short> getDamage() {
        return this.damage;
    }

    public Set<CompoundTag> getParsedTags() {
        if (this.parsedTags == null) {
            if (this.tags.isEmpty()) {
                this.parsedTags = Collections.emptySet();
            } else {
                this.parsedTags = new HashSet<CompoundTag>(this.tags.size());
                for (String tag : this.tags) {
                    try {
                        CompoundTag ench;
                        ListTag enchList;
                        CompoundTag compoundTag = Main.getInstance().getTools().getNbtUtils().parseString(tag);
                        this.parsedTags.add(compoundTag);
                        if (!compoundTag.containsKey("StoredEnchantments", TagType.LIST) || (enchList = compoundTag.getList("StoredEnchantments")).size() != 1 || enchList.getElementType() != TagType.COMPOUND || !(ench = enchList.getCompound(0)).containsKey("lvl", TagType.SHORT)) continue;
                        for (int level = ench.getShort("lvl") - 1; level >= 1; --level) {
                            CompoundTag compoundTag2 = Main.getInstance().getTools().getNbtUtils().parseString(tag);
                            ListTag enchList2 = compoundTag2.getList("StoredEnchantments");
                            enchList2.getCompound(0).setShort("lvl", (short)level);
                            this.parsedTags.add(compoundTag2);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.parsedTags;
    }
}

