/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.cyberiantiger.minecraft.itemcontrol.config.Action;
import org.cyberiantiger.minecraft.itemcontrol.config.Blacklist;
import org.cyberiantiger.minecraft.itemcontrol.config.Config;
import org.cyberiantiger.minecraft.itemcontrol.event.BlockedCreativeInventoryActionEvent;
import org.cyberiantiger.minecraft.itemcontrol.items.ItemGroup;
import org.cyberiantiger.minecraft.itemcontrol.items.ItemGroups;
import org.cyberiantiger.minecraft.itemcontrol.items.ItemType;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.TagType;
import org.cyberiantiger.minecraft.unsafe.CBShim;
import org.cyberiantiger.minecraft.unsafe.NBTTools;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class Main
extends JavaPlugin
implements Listener {
    private static final String PERMISSION_BYPASS = "creativeitemcontrol.bypass";
    private static final String PERMISSION_BLACKLIST_BYPASS = "creativeitemcontrol.blacklist.*";
    private static final String PERMISSION_MENU_PREFIX = "creativeitemcontrol.menu.";
    private static final String PERMISSION_BLACKLIST_PREFIX = "creativeitemcontrol.blacklist.";
    private static final ItemStack EMPTY_CURSOR = new ItemStack(Material.AIR);
    private static final String CONFIG = "config.yml";
    private static final String ITEMS = "items.yml";
    private static final Set<Material> BANNER_ITEMS = Collections.unmodifiableSet(new HashSet<Material>(List.of(Material.BLACK_BANNER, Material.BLUE_BANNER, Material.BROWN_BANNER, Material.CYAN_BANNER, Material.GRAY_BANNER, Material.GREEN_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIME_BANNER, Material.MAGENTA_BANNER, Material.ORANGE_BANNER, Material.PINK_BANNER, Material.PURPLE_BANNER, Material.RED_BANNER, Material.WHITE_BANNER, Material.YELLOW_BANNER)));
    private Map<Object, PlayerState> playerStates = new WeakHashMap<Object, PlayerState>();
    private NBTTools tools;
    private Config config;
    private ItemGroups itemGroups;

    private File getDataFile(String name) {
        return new File(this.getDataFolder(), name);
    }

    private Reader openFile(File file) throws IOException {
        return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), Charsets.UTF_8);
    }

    private Reader openDataFile(String file) throws IOException {
        return this.openFile(this.getDataFile(file));
    }

    private Reader openResource(String resource) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
        if (in == null) {
            throw new FileNotFoundException(resource);
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(in), Charsets.UTF_8);
    }

    private void loadConfig() {
        this.config = new Config();
        try {
            Yaml configLoader = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(Config.class, ((Object)((Object)this)).getClass().getClassLoader(), new LoaderOptions()));
            configLoader.setBeanAccess(BeanAccess.FIELD);
            this.config = (Config)configLoader.loadAs(this.openDataFile(CONFIG), Config.class);
            Permission parent = this.getServer().getPluginManager().getPermission(PERMISSION_BLACKLIST_BYPASS);
            if (parent == null) {
                parent = new Permission(PERMISSION_BLACKLIST_BYPASS);
                this.getServer().getPluginManager().addPermission(parent);
            }
            for (String s : this.config.getBlacklist().keySet()) {
                Permission child = this.getServer().getPluginManager().getPermission(PERMISSION_BLACKLIST_PREFIX + s);
                if (child != null) continue;
                child = new Permission(PERMISSION_BLACKLIST_PREFIX + s);
                this.getServer().getPluginManager().addPermission(child);
                child.addParent(parent, true);
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error loading config.yml", ex);
            this.getLogger().severe("Your config.yml has fatal errors, using defaults.");
        }
        catch (YAMLException ex) {
            this.getLogger().log(Level.SEVERE, "Error loading config.yml", ex);
            this.getLogger().severe("Your config.yml has fatal errors, using defaults.");
        }
    }

    private void loadItems() {
        this.itemGroups = new ItemGroups();
        try {
            Yaml configLoader = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(ItemGroups.class, ((Object)((Object)this)).getClass().getClassLoader(), new LoaderOptions()));
            configLoader.setBeanAccess(BeanAccess.FIELD);
            this.itemGroups = (ItemGroups)configLoader.loadAs(this.openResource(ITEMS), ItemGroups.class);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error loading config.yml", ex);
            this.getLogger().severe("Your config.yml has fatal errors, using defaults.");
        }
        catch (YAMLException ex) {
            this.getLogger().log(Level.SEVERE, "Error loading config.yml", ex);
            this.getLogger().severe("Your config.yml has fatal errors, using defaults.");
        }
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.tools = CBShim.createShim(NBTTools.class, (Plugin)this, new Object[0]);
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadItems();
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.loadConfig();
        this.playerStates.clear();
        sender.sendMessage("CreativeItemControl " + this.getDescription().getVersion() + " reloaded.");
        return true;
    }

    private PlayerState getPlayerState(Object player) {
        PlayerState result = this.playerStates.get(player);
        if (result == null) {
            result = new PlayerState();
            this.playerStates.put(player, result);
        }
        return result;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreativeEvent(InventoryCreativeEvent e) {
        HumanEntity whoClicked = e.getWhoClicked();
        if (whoClicked instanceof Player && whoClicked.getGameMode() == GameMode.CREATIVE) {
            ItemStack cursor;
            ItemStack expectedCursor;
            if (whoClicked.hasPermission(PERMISSION_BYPASS)) {
                return;
            }
            PlayerState state = this.getPlayerState(whoClicked);
            if (!state.testClick()) {
                Action action = this.config.getOnRateLimit();
                this.performAction(this.config.getOnRateLimit(), (Player)whoClicked, null);
                if (action.isBlock()) {
                    e.setCancelled(true);
                    return;
                }
            }
            if ((expectedCursor = state.getLastItem()) == null) {
                expectedCursor = EMPTY_CURSOR;
            }
            if ((cursor = e.getCursor()) == null || cursor.getType() == Material.AIR) {
                return;
            }
            CompoundTag clickedTag = this.tools.readItemStack(cursor);
            if (clickedTag != null) {
                if (!whoClicked.hasPermission(PERMISSION_BLACKLIST_BYPASS) && !this.checkBlacklist(whoClicked, clickedTag)) {
                    e.setCancelled(true);
                    return;
                }
                if (!(cursor.isSimilar(expectedCursor) || this.isInInventory(whoClicked.getInventory(), cursor) || this.isAroundPlayer(whoClicked, cursor, clickedTag) || this.checkMenuAccess(whoClicked, clickedTag))) {
                    e.setCancelled(true);
                    return;
                }
            }
        }
    }

    private boolean isAroundPlayer(HumanEntity player, ItemStack cursor, CompoundTag cursorTag) {
        CompoundTag tagBlockEntityTag;
        CompoundTag tagData;
        CompoundTag skullOwnerData;
        CompoundTag headData;
        List nearby = player.getNearbyEntities(6.0, 6.0, 6.0);
        for (Entity e : nearby) {
            if (e instanceof ItemFrame) {
                if (!this.isSimilar(((ItemFrame)e).getItem(), cursor)) continue;
                return true;
            }
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand as = (ArmorStand)e;
            if (this.isSimilar(as.getEquipment().getBoots(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getLeggings(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getChestplate(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getHelmet(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getItemInMainHand(), cursor)) {
                return true;
            }
            if (!this.isSimilar(as.getEquipment().getItemInOffHand(), cursor)) continue;
            return true;
        }
        if (cursor.getType() == Material.PLAYER_HEAD && (headData = cursorTag.getCompound("tag")) != null && (skullOwnerData = headData.getCompound("SkullOwner")) != null && headData.getValue().size() == 1) {
            Location playerLocation = player.getLocation();
            int playerX = playerLocation.getBlockX();
            int playerZ = playerLocation.getBlockZ();
            int minChunkX = playerX - 7 >> 4;
            int maxChunkX = playerX + 7 >> 4;
            int minChunkZ = playerZ - 7 >> 4;
            int maxChunkZ = playerZ + 7 >> 4;
            Location blockLocation = playerLocation.clone();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    Chunk chunk = playerLocation.getWorld().getChunkAt(chunkX, chunkZ);
                    for (BlockState bs : chunk.getTileEntities()) {
                        CompoundTag existingSkullOwnerData;
                        CompoundTag skullTag;
                        if (!(bs instanceof Skull)) continue;
                        bs.getLocation(blockLocation);
                        if (!(blockLocation.distanceSquared(playerLocation) < 49.0) || (skullTag = this.tools.readTileEntity(bs.getBlock())) == null || (existingSkullOwnerData = skullTag.getCompound("SkullOwner")) == null || !existingSkullOwnerData.equals(skullOwnerData)) continue;
                        return true;
                    }
                }
            }
        }
        if (BANNER_ITEMS.contains(cursor.getType()) && (tagData = cursorTag.getCompound("tag")) != null && (tagBlockEntityTag = tagData.getCompound("BlockEntityTag")) != null) {
            ListTag patternsTag = tagBlockEntityTag.getList("Patterns");
            Location playerLocation = player.getLocation();
            int playerX = playerLocation.getBlockX();
            int playerZ = playerLocation.getBlockZ();
            int minChunkX = playerX - 7 >> 4;
            int maxChunkX = playerX + 7 >> 4;
            int minChunkZ = playerZ - 7 >> 4;
            int maxChunkZ = playerZ + 7 >> 4;
            Location blockLocation = playerLocation.clone();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    Chunk chunk = playerLocation.getWorld().getChunkAt(chunkX, chunkZ);
                    for (BlockState bs : chunk.getTileEntities()) {
                        ListTag existingPatternsTag;
                        CompoundTag bannerTag;
                        if (!(bs instanceof Banner)) continue;
                        bs.getLocation(blockLocation);
                        if (!(blockLocation.distanceSquared(playerLocation) < 49.0) || (bannerTag = this.tools.readTileEntity(bs.getBlock())) == null || !Objects.equal((Object)(existingPatternsTag = bannerTag.getList("Patterns")), (Object)patternsTag)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isSimilar(ItemStack item, ItemStack cursor) {
        return item != null && cursor != null && item.isSimilar(cursor);
    }

    private boolean isInInventory(PlayerInventory inventory, ItemStack cursor) {
        for (ItemStack contentStack : inventory.getContents()) {
            if (contentStack == null || !contentStack.isSimilar(cursor)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        Item item;
        CompoundTag itemTag;
        Player p = e.getPlayer();
        if (p.hasPermission(PERMISSION_BLACKLIST_BYPASS)) {
            return;
        }
        PlayerState state = this.getPlayerState(p);
        if (!state.testClick()) {
            Action action = this.config.getOnRateLimit();
            this.performAction(this.config.getOnRateLimit(), p, null);
            if (action.isBlock()) {
                e.setCancelled(true);
                return;
            }
        }
        if (!this.checkBlacklist((HumanEntity)p, itemTag = this.tools.readItemStack((item = e.getItemDrop()).getItemStack()))) {
            e.setCancelled(true);
            item.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(EntityPickupItemEvent e) {
        LivingEntity ent = e.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        Player p = (Player)ent;
        if (p.hasPermission(PERMISSION_BLACKLIST_BYPASS)) {
            return;
        }
        Item item = e.getItem();
        CompoundTag itemTag = this.tools.readItemStack(item.getItemStack());
        if (!this.checkBlacklist((HumanEntity)p, itemTag)) {
            e.setCancelled(true);
            item.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission(PERMISSION_BLACKLIST_BYPASS)) {
            return;
        }
        ItemStack item = e.getItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        CompoundTag itemTag = this.tools.readItemStack(item);
        if (!this.checkBlacklist((HumanEntity)p, itemTag)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void monitorInventoryCreative(InventoryCreativeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        HumanEntity whoClicked = e.getWhoClicked();
        if (whoClicked instanceof Player && whoClicked.getGameMode() == GameMode.CREATIVE) {
            PlayerState state = this.getPlayerState(whoClicked);
            state.setLastItem(e.getCurrentItem());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void monitorInventoryClose(InventoryCloseEvent e) {
        this.getPlayerState(e.getPlayer()).setLastItem(null);
    }

    private boolean checkMenuAccess(HumanEntity whoClicked, CompoundTag itemTag) {
        Action action;
        CompoundTag tag;
        boolean found = false;
        boolean hasAccess = false;
        String itemId = itemTag.containsKey("id", TagType.STRING) ? itemTag.getString("id") : null;
        CompoundTag compoundTag = tag = itemTag.containsKey("tag", TagType.COMPOUND) ? itemTag.getCompound("tag") : null;
        if (itemId != null) {
            if (this.config.getWhitelist().contains(itemId)) {
                found = true;
                hasAccess = true;
            } else if (tag == null) {
                found = true;
                hasAccess = true;
            } else {
                for (Map.Entry<String, ItemGroup> e : this.itemGroups.getGroups().entrySet()) {
                    String name = e.getKey();
                    ItemGroup group = e.getValue();
                    ItemType type = group.getItems().get(itemId);
                    if (type == null) continue;
                    if (tag != null && tag.containsKey("Damage", TagType.INT)) {
                        tag.remove("Damage");
                        if (tag.getValue().isEmpty()) {
                            tag = null;
                        }
                    }
                    if (tag != null && !type.getParsedTags().contains(tag)) continue;
                    found = true;
                    if (!whoClicked.hasPermission(PERMISSION_MENU_PREFIX + name)) continue;
                    hasAccess = true;
                }
                if (!hasAccess && this.config.getAllowedItems().contains(itemId) && tag == null) {
                    found = true;
                    hasAccess = true;
                }
            }
        }
        if (!found && (action = this.config.getUnavailable()).isBlock()) {
            this.performAction(action, (Player)whoClicked, itemTag);
            return hasAccess;
        }
        if (!hasAccess && (action = this.config.getNopermission()).isBlock()) {
            this.performAction(action, (Player)whoClicked, itemTag);
            return hasAccess;
        }
        return true;
    }

    private boolean checkBlacklist(HumanEntity whoClicked, CompoundTag itemTag) {
        Action blacklistAction = this.config.getBlacklisted();
        if (!blacklistAction.isBlock()) {
            return true;
        }
        String itemId = itemTag.getString("id");
        if (itemId == null) {
            return false;
        }
        for (Map.Entry<String, Blacklist> e : this.config.getBlacklist().entrySet()) {
            String name = e.getKey();
            Blacklist value = e.getValue();
            if (whoClicked.hasPermission(PERMISSION_BLACKLIST_PREFIX + name) || !value.getItems().contains(itemId)) continue;
            this.performAction(blacklistAction, (Player)whoClicked, itemTag);
            return false;
        }
        return true;
    }

    private void performAction(Action action, Player player, CompoundTag itemTag) {
        String name = player.getName();
        String id = itemTag == null ? null : itemTag.getString("id");
        String fullItem = itemTag == null ? null : itemTag.toString();
        Object item = fullItem;
        if (item != null && ((String)item).length() > 5000) {
            item = ((String)item).substring(0, 5000) + " + [" + (((String)item).length() - 5000) + " bytes]";
        }
        if (action.getMessage() != null) {
            player.sendMessage(String.format(action.getMessage(), name, id, item));
        }
        if (action.getBroadcastMessage() != null) {
            this.getServer().broadcast(String.format(action.getBroadcastMessage(), name, id, item), action.getBroadcastPermission());
        }
        for (String s : action.getCommands()) {
            this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), String.format(s, name, id, item));
        }
        this.getServer().getPluginManager().callEvent((Event)new BlockedCreativeInventoryActionEvent(player, action, itemTag, fullItem));
    }

    private class PlayerState {
        private ItemStack lastItem;
        private final long[] clickTimes;
        private int clickTimesOffset;

        public PlayerState() {
            if (Main.this.config.getRateLimit() > 0) {
                this.clickTimesOffset = 0;
                this.clickTimes = new long[Main.this.config.getRateLimit()];
                Arrays.fill(this.clickTimes, Long.MIN_VALUE);
            } else {
                this.clickTimes = null;
            }
        }

        public ItemStack getLastItem() {
            return this.lastItem;
        }

        public void setLastItem(ItemStack lastItem) {
            this.lastItem = lastItem;
        }

        public boolean testClick() {
            if (this.clickTimes != null) {
                long now = System.nanoTime();
                this.clickTimes[this.clickTimesOffset++] = now;
                if (this.clickTimesOffset >= this.clickTimes.length) {
                    this.clickTimesOffset = 0;
                }
                return this.clickTimes[this.clickTimesOffset] < now - TimeUnit.SECONDS.toNanos(Main.this.config.getRateLimitTime());
            }
            return true;
        }
    }
}

