/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.EndTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagInputStream;
import org.cyberiantiger.minecraft.nbt.TagOutputStream;
import org.cyberiantiger.minecraft.nbt.TagTuple;

public enum TagType {
    END(null, null){

        public Tag read(TagInputStream in) throws IOException {
            return EndTag.VALUE;
        }

        public void write(Tag tag, TagOutputStream out) throws IOException {
        }

        @Override
        public String readName(TagInputStream in) throws IOException {
            return null;
        }

        @Override
        public void writeName(String name, TagOutputStream out) throws IOException {
        }

        public EndTag[] newArray(int size) {
            throw new IllegalStateException("Cannot construct arrays of end tags");
        }
    }
    ,
    BYTE(ByteTag.class, (Class)Byte.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeByte(((ByteTag)tag).getRawValue());
        }

        public ByteTag read(TagInputStream in) throws IOException {
            return new ByteTag(in.readByte());
        }

        public ByteTag[] newArray(int size) {
            return new ByteTag[size];
        }
    }
    ,
    SHORT(ShortTag.class, (Class)Short.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeShort(((ShortTag)tag).getRawValue());
        }

        public ShortTag read(TagInputStream in) throws IOException {
            return new ShortTag(in.readShort());
        }

        public ShortTag[] newArray(int size) {
            return new ShortTag[size];
        }
    }
    ,
    INT(IntTag.class, (Class)Integer.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeInt(((IntTag)tag).getRawValue());
        }

        public IntTag read(TagInputStream in) throws IOException {
            return new IntTag(in.readInt());
        }

        public IntTag[] newArray(int size) {
            return new IntTag[size];
        }
    }
    ,
    LONG(LongTag.class, (Class)Long.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeLong(((LongTag)tag).getRawValue());
        }

        public LongTag read(TagInputStream in) throws IOException {
            return new LongTag(in.readLong());
        }

        public LongTag[] newArray(int size) {
            return new LongTag[size];
        }
    }
    ,
    FLOAT(FloatTag.class, (Class)Float.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeFloat(((FloatTag)tag).getRawValue());
        }

        public FloatTag read(TagInputStream in) throws IOException {
            return new FloatTag(in.readFloat());
        }

        public FloatTag[] newArray(int size) {
            return new FloatTag[size];
        }
    }
    ,
    DOUBLE(DoubleTag.class, (Class)Double.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeDouble(((DoubleTag)tag).getRawValue());
        }

        public DoubleTag read(TagInputStream in) throws IOException {
            return new DoubleTag(in.readDouble());
        }

        public DoubleTag[] newArray(int size) {
            return new DoubleTag[size];
        }
    }
    ,
    BYTE_ARRAY(ByteArrayTag.class, (Class)byte[].class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            byte[] data = ((ByteArrayTag)tag).getValue();
            out.writeInt(data.length);
            out.write(data);
        }

        public ByteArrayTag read(TagInputStream in) throws IOException {
            int length = in.readInt();
            byte[] value = new byte[length];
            in.readFully(value);
            return new ByteArrayTag(value);
        }

        public ByteArrayTag[] newArray(int size) {
            return new ByteArrayTag[size];
        }
    }
    ,
    STRING(StringTag.class, (Class)String.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            out.writeMCString(((StringTag)tag).getValue());
        }

        public StringTag read(TagInputStream in) throws IOException {
            return new StringTag(in.readMCString());
        }

        public StringTag[] newArray(int size) {
            return new StringTag[size];
        }
    }
    ,
    LIST(ListTag.class, (Class)Tag[].class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            TagType type = ((ListTag)tag).getListType();
            Tag[] values = ((ListTag)tag).getValue();
            out.writeByte(type.ordinal());
            if (values == null) {
                out.writeInt(0);
            } else {
                out.writeInt(values.length);
                for (int i = 0; i < values.length; ++i) {
                    type.write(values[i], out);
                }
            }
        }

        public ListTag read(TagInputStream in) throws IOException {
            TagType type = TagType.values()[in.readByte()];
            int length = in.readInt();
            if (type == END) {
                if (length == 0) {
                    return new ListTag(type, null);
                }
                throw new IOException("Illegal list tag, had type of 0 and non-zero length");
            }
            Tag[] value = (Tag[])Array.newInstance(type.getTagClass(), length);
            for (int i = 0; i < length; ++i) {
                value[i] = type.read(in);
            }
            return new ListTag(type, value);
        }

        public ListTag[] newArray(int size) {
            return new ListTag[size];
        }
    }
    ,
    COMPOUND(CompoundTag.class, (Class)Map.class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            for (Map.Entry e : ((CompoundTag)tag).getValue().entrySet()) {
                out.writeTag(e);
            }
            out.writeTag(EndTag.TUPLE);
        }

        public CompoundTag read(TagInputStream in) throws IOException {
            TagTuple tag;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            while (((Tag)(tag = in.readTag()).getValue()).getType() != END) {
                values.put(tag.getKey(), (Tag)tag.getValue());
            }
            return new CompoundTag(values);
        }

        public CompoundTag[] newArray(int size) {
            return new CompoundTag[size];
        }
    }
    ,
    INT_ARRAY(IntArrayTag.class, (Class)int[].class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            int[] value = ((IntArrayTag)tag).getValue();
            out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                out.writeInt(value[i]);
            }
        }

        public IntArrayTag read(TagInputStream in) throws IOException {
            int length = in.readInt();
            int[] value = new int[length];
            for (int i = 0; i < length; ++i) {
                value[i] = in.readInt();
            }
            return new IntArrayTag(value);
        }

        public IntArrayTag[] newArray(int size) {
            return new IntArrayTag[size];
        }
    }
    ,
    LONG_ARRAY(LongArrayTag.class, (Class)long[].class){

        public void write(Tag tag, TagOutputStream out) throws IOException {
            long[] value = ((LongArrayTag)tag).getValue();
            out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                out.writeLong(value[i]);
            }
        }

        public LongArrayTag read(TagInputStream in) throws IOException {
            int length = in.readInt();
            long[] value = new long[length];
            for (int i = 0; i < length; ++i) {
                value[i] = in.readLong();
            }
            return new LongArrayTag(value);
        }

        public LongArrayTag[] newArray(int size) {
            return new LongArrayTag[size];
        }
    };

    private final Class<? extends Tag> tagClass;
    private final Class<?> valueClass;

    private TagType(Class<? extends Tag> tagClass, Class<?> valueClass) {
        this.tagClass = tagClass;
        this.valueClass = valueClass;
    }

    public Class<? extends Tag> getTagClass() {
        return this.tagClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public abstract <T extends Tag> T read(TagInputStream var1) throws IOException;

    public String readName(TagInputStream in) throws IOException {
        return in.readMCString();
    }

    public abstract <T extends Tag> void write(T var1, TagOutputStream var2) throws IOException;

    public void writeName(String name, TagOutputStream out) throws IOException {
        out.writeMCString(name);
    }

    public abstract <T extends Tag> T[] newArray(int var1);
}

