/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_10;

import de.cubeside.itemcontrol.libs.nmsutils.BiomeUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.biome.CustomBiome;
import de.cubeside.itemcontrol.libs.nmsutils.biome.Precipitation;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_10.NMSUtilsImpl;
import de.cubeside.itemcontrol.libs.nmsutils.util.ReobfHelper;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class BiomeUtilsImpl
implements BiomeUtils {
    private final NMSUtilsImpl nmsUtils;
    private static final Field FIELD_MAPPED_REGISTRY_FROZEN = ReobfHelper.getFieldByMojangName(RegistryMaterials.class, "frozen");
    private static final Field FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS = ReobfHelper.getFieldByMojangName(RegistryMaterials.class, "unregisteredIntrusiveHolders");
    private static final Field FIELD_MAPPED_HOLDER_REFERENCE_TAGS = ReobfHelper.getFieldByMojangName(Holder.c.class, "tags");

    public BiomeUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public Biome registerBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        Server server = this.nmsUtils.getPlugin().getServer();
        CraftServer craftserver = (CraftServer)server;
        DedicatedServer dedicatedserver = craftserver.getServer();
        ResourceKey newKey = ResourceKey.a((ResourceKey)Registries.aN, (MinecraftKey)MinecraftKey.a((String)id.getNamespace(), (String)id.getKey()));
        ResourceKey oldKey = Biomes.i;
        IRegistryWritable registrywritable = (IRegistryWritable)dedicatedserver.bg().f(Registries.aN);
        try {
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, false);
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        BiomeBase forestbiome = (BiomeBase)registrywritable.c(oldKey);
        BiomeBase.a builder = new BiomeBase.a();
        builder.b(downfall);
        builder.a(temperature);
        boolean mojangPrecipitation = false;
        if (precipitation == Precipitation.RAIN) {
            mojangPrecipitation = true;
        } else if (precipitation == Precipitation.SNOW) {
            mojangPrecipitation = true;
        }
        builder.a(mojangPrecipitation);
        builder.a(forestbiome.b());
        builder.a(forestbiome.d());
        builder.a(BiomeBase.TemperatureModifier.a);
        BiomeFog.a effects = new BiomeFog.a();
        effects.b(waterColor == null ? forestbiome.j() : waterColor.intValue());
        effects.c(waterFogColor == null ? forestbiome.k() : waterFogColor.intValue());
        effects.a(fogColor == null ? forestbiome.e() : fogColor.intValue());
        effects.d(skyColor == null ? forestbiome.a() : skyColor.intValue());
        if (foliageColor != null) {
            effects.e(foliageColor.intValue());
        }
        if (grassColor != null) {
            effects.g(grassColor.intValue());
        }
        effects.a(CaveSoundSettings.b);
        BiomeFog.GrassColor nativeGrassColorModifier = switch (grassColorModifier) {
            case BiomeUtils.GrassColorModifier.DARK_FOREST -> BiomeFog.GrassColor.b;
            case BiomeUtils.GrassColorModifier.SWAMP -> BiomeFog.GrassColor.c;
            default -> BiomeFog.GrassColor.a;
        };
        effects.a(nativeGrassColorModifier);
        builder.a(effects.b());
        BiomeBase newbiome = builder.a();
        registrywritable.f((Object)newbiome);
        Holder.c biomeHolder = registrywritable.a(newKey, (Object)newbiome, RegistrationInfo.a);
        try {
            FIELD_MAPPED_HOLDER_REFERENCE_TAGS.set(biomeHolder, Set.of());
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, null);
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return (Biome)RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME).get(id);
    }

    @Override
    public CustomBiome registerCustomBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        this.registerBiome(id, downfall, temperature, precipitation, fogColor, waterColor, waterFogColor, skyColor, foliageColor, grassColor, grassColorModifier);
        return null;
    }

    @Override
    public Collection<? extends CustomBiome> getAllCustomBiomes() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public CustomBiome getCustomBiomeAt(Location location) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public CustomBiome getCustomBiome(NamespacedKey id) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public BiomeProvider getVanillaOverworldBiomeProvider(long seed) {
        RandomState randomState;
        final WorldDimension stem = (WorldDimension)MinecraftServer.getServer().bg().f(Registries.by).c(WorldDimension.b);
        ChunkGenerator chunkGenerator = stem.b();
        if (chunkGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)chunkGenerator;
            randomState = RandomState.a((GeneratorSettingBase)((GeneratorSettingBase)noiseBasedChunkGenerator.h().a()), (HolderGetter)MinecraftServer.getServer().bg().f(Registries.bg), (long)seed);
        } else {
            randomState = RandomState.a((GeneratorSettingBase)GeneratorSettingBase.e(), (HolderGetter)MinecraftServer.getServer().bg().f(Registries.bg), (long)seed);
        }
        final List<Biome> possibleBiomes = stem.b().d().c().stream().map(biome -> CraftBiome.minecraftHolderToBukkit((Holder)biome)).toList();
        return new BiomeProvider(this){

            public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit((Holder)stem.b().d().getNoiseBiome(x >> 2, y >> 2, z >> 2, randomState.b()));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }
}

