/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.HoverEvent;

public final class ComponentExpansionLimiter {
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private ComponentExpansionLimiter() {
    }

    public static boolean checkExpansions(Component component, long maxExpansions) {
        try {
            ComponentExpansionLimiter.checkExpansionsInternal(component, maxExpansions);
            return true;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            return false;
        }
    }

    private static long checkExpansionsInternal(Component component, long maxExpansions) throws IllegalArgumentException {
        List extra;
        Component text;
        HoverEvent hoverEvent;
        long expansions = 0L;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            expansions += ComponentExpansionLimiter.getTranslationExpansions(translatable, maxExpansions);
        }
        if ((hoverEvent = component.hoverEvent()) != null && hoverEvent.action() == HoverEvent.Action.SHOW_TEXT && (text = (Component)hoverEvent.value()) != null) {
            expansions += ComponentExpansionLimiter.checkExpansionsInternal(text, maxExpansions);
        }
        if ((extra = component.children()) != null) {
            for (Component extraComponent : extra) {
                expansions += ComponentExpansionLimiter.checkExpansionsInternal(extraComponent, maxExpansions);
            }
        }
        if (expansions > maxExpansions) {
            throw new IllegalArgumentException("Too many component expansions!");
        }
        return expansions;
    }

    private static long getTranslationExpansions(TranslatableComponent component, long maxExpansions) throws IllegalArgumentException {
        HashMap<TranslationArgument, Integer> expansionCounts = new HashMap<TranslationArgument, Integer>();
        String trans = component.fallback();
        long expansions = 0L;
        if (trans != null) {
            Matcher matcher = TRANSLATION_PATTERN.matcher(trans);
            int position = 0;
            int i = 0;
            while (matcher.find(position)) {
                position = matcher.end();
                String formatCode = matcher.group(2);
                switch (formatCode.charAt(0)) {
                    case 'd': 
                    case 's': {
                        String withIndex = matcher.group(1);
                        TranslationArgument withComponent = (TranslationArgument)component.arguments().get(withIndex != null ? Integer.parseInt(withIndex) - 1 : i++);
                        expansionCounts.merge(withComponent, 1, Integer::sum);
                    }
                }
            }
            for (Map.Entry e : expansionCounts.entrySet()) {
                expansions += (ComponentExpansionLimiter.checkExpansionsInternal(((TranslationArgument)e.getKey()).asComponent(), maxExpansions) + 1L) * (long)((Integer)e.getValue()).intValue();
            }
        } else {
            for (TranslationArgument e : component.arguments()) {
                expansions += ComponentExpansionLimiter.checkExpansionsInternal(e.asComponent(), maxExpansions) + 1L;
            }
        }
        return expansions;
    }
}

