/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.ComponentExpansionLimiter;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckLore
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:lore");
    private int maxLines;
    private int maxLength;
    private boolean allow;
    private boolean allowFormating;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, this.getComponentKey().asMinimalString());
        this.maxLines = ConfigUtil.getOrCreate(data, "max_lines", 40);
        this.maxLength = ConfigUtil.getOrCreate(data, "max_length", 40);
        this.allow = ConfigUtil.getOrCreate(data, "allow", false);
        this.allowFormating = ConfigUtil.getOrCreate(data, "allow_formating", false);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        ListTag loreTag = itemComponentsTag.getList(key);
        if (this.allow && loreTag != null) {
            for (int i = loreTag.size() - 1; i >= 0; --i) {
                Component component = loreTag.getTextComponent(i);
                if (component != null) {
                    try {
                        if (!ComponentExpansionLimiter.checkExpansions(component, group.getMaxComponentExpansions())) {
                            loreTag.remove(i);
                            changed = true;
                            continue;
                        }
                        String plain = PlainTextComponentSerializer.plainText().serialize(component);
                        if (plain.length() > this.maxLength) {
                            loreTag.remove(i);
                            changed = true;
                            continue;
                        }
                        if (this.allowFormating) continue;
                        loreTag.setTextComponent(i, (Component)Component.text((String)plain));
                        changed = true;
                    }
                    catch (IllegalArgumentException e) {
                        loreTag.remove(i);
                        changed = true;
                    }
                    continue;
                }
                loreTag.remove(i);
                changed = true;
            }
            while (loreTag.size() > this.maxLines && loreTag.size() > 0) {
                loreTag.remove(loreTag.getInt(loreTag.size() - 1));
                changed = true;
            }
            if (loreTag.size() == 0) {
                itemComponentsTag.remove(key);
                changed = true;
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }
}

