/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol;

import de.cubeside.itemcontrol.ItemChecker;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.config.PluginConfig;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private static final String PERMISSION_BYPASS = "creativeitemcontrol.bypass";
    private static final ItemStack EMPTY_CURSOR = new ItemStack(Material.AIR);
    private File configFile;
    YamlConfiguration yamlConfig;
    private Map<UUID, PlayerState> playerStates = new HashMap<UUID, PlayerState>();
    private NMSUtils tools;
    private PluginConfig pluginConfig;
    private static Main instance;

    public Main() {
        instance = this;
    }

    public static Main getInstance() {
        return instance;
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.tools = NMSUtils.createInstance((Plugin)this);
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (this.configFile.isFile() && this.getConfig().contains("allowedItems")) {
            File configBackupFile = new File(this.getDataFolder(), "config.backup.yml");
            if (configBackupFile.exists()) {
                configBackupFile.delete();
            }
            this.configFile.renameTo(configBackupFile);
        }
        this.saveDefaultConfig();
        this.reloadConfig();
    }

    public void reloadConfig() {
        block3: {
            super.reloadConfig();
            this.yamlConfig = new YamlConfiguration();
            try {
                this.yamlConfig.load(this.configFile);
                InputStream defConfigStream = this.getResource("config.yml");
                if (defConfigStream != null) {
                    this.yamlConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Could not load config file: " + e.getMessage());
                if (!this.configFile.isFile()) break block3;
                File configBackupFile = new File(this.getDataFolder(), "config." + System.currentTimeMillis() + ".yml");
                this.configFile.renameTo(configBackupFile);
                this.saveDefaultConfig();
                this.reloadConfig();
                return;
            }
        }
        this.pluginConfig = new PluginConfig(this, this.yamlConfig);
    }

    public void saveConfig() {
        try {
            this.yamlConfig.save(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not load config file: " + e.getMessage(), e);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.reloadConfig();
        this.playerStates.clear();
        sender.sendMessage((Component)Component.text((String)"CreativeItemControl reloaded.", (TextColor)NamedTextColor.GREEN));
        return true;
    }

    private PlayerState getPlayerState(Player player) {
        return this.playerStates.computeIfAbsent(player.getUniqueId(), uuid -> new PlayerState(this));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreativeEvent(InventoryCreativeEvent e) {
        Player player;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player && (player = (Player)humanEntity).getGameMode() == GameMode.CREATIVE) {
            Material m;
            if (player.hasPermission(PERMISSION_BYPASS)) {
                return;
            }
            PlayerState state = this.getPlayerState(player);
            ItemStack expectedCursor = state.getLastItem();
            ItemStack cursor = e.getCursor();
            Material material = m = cursor == null ? Material.AIR : cursor.getType();
            if (m == Material.AIR) {
                return;
            }
            CompoundTag clickedTag = this.tools.getNbtUtils().getItemStackNbt(cursor);
            if (cursor.isSimilar(expectedCursor) || this.isInInventory(player.getInventory(), cursor) || this.isAroundPlayer(player, cursor, clickedTag)) {
                return;
            }
            GroupConfig group = this.pluginConfig.getGroup(player);
            if (group.getForbiddenItems().contains(m)) {
                if (this.pluginConfig.getUnavailableMessage() != null) {
                    player.sendMessage((Component)Component.text((String)this.pluginConfig.getUnavailableMessage().replace("$itemtype$", m.getKey().asMinimalString()), (TextColor)NamedTextColor.DARK_RED));
                }
                e.setCancelled(true);
                return;
            }
            byte[] serialized = this.tools.getNbtUtils().writeBinary(clickedTag);
            if (group.getMaxItemSizeBytes() >= 0 && serialized.length > group.getMaxItemSizeBytes()) {
                if (this.pluginConfig.getTooLargeMessage() != null) {
                    player.sendMessage((Component)Component.text((String)this.pluginConfig.getTooLargeMessage().replace("$itemtype$", m.getKey().asMinimalString()), (TextColor)NamedTextColor.DARK_RED));
                }
                e.setCancelled(true);
                return;
            }
            if (clickedTag != null) {
                Boolean modified;
                if (this.pluginConfig.isDebug()) {
                    this.getLogger().info("Input from " + player.getName() + ": " + this.tools.getNbtUtils().writeString(clickedTag));
                }
                if ((modified = ItemChecker.filterItem(clickedTag, group)) == null) {
                    if (this.pluginConfig.getUnavailableMessage() != null) {
                        player.sendMessage((Component)Component.text((String)this.pluginConfig.getUnavailableMessage().replace("$itemtype$", m.getKey().asMinimalString()), (TextColor)NamedTextColor.DARK_RED));
                    }
                    e.setCancelled(true);
                    return;
                }
                if (this.pluginConfig.isDebug()) {
                    this.getLogger().info("Result: " + this.tools.getNbtUtils().writeString(clickedTag));
                }
                if (modified.booleanValue()) {
                    ItemStack newStack = this.tools.getNbtUtils().createItemStack(clickedTag);
                    if (newStack == null) {
                        newStack = new ItemStack(Material.AIR);
                    }
                    e.setCursor(newStack);
                }
            }
        }
    }

    private boolean isInInventory(PlayerInventory inventory, ItemStack cursor) {
        for (ItemStack contentStack : inventory.getContents()) {
            if (!this.isSimilar(contentStack, cursor)) continue;
            return true;
        }
        return false;
    }

    private boolean isAroundPlayer(Player player, ItemStack cursor, CompoundTag cursorTag) {
        List nearby = player.getNearbyEntities(6.0, 6.0, 6.0);
        for (Entity e : nearby) {
            if (e instanceof ItemFrame) {
                if (!this.isSimilar(((ItemFrame)e).getItem(), cursor)) continue;
                return true;
            }
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand as = (ArmorStand)e;
            if (this.isSimilar(as.getEquipment().getBoots(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getLeggings(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getChestplate(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getHelmet(), cursor)) {
                return true;
            }
            if (this.isSimilar(as.getEquipment().getItemInMainHand(), cursor)) {
                return true;
            }
            if (!this.isSimilar(as.getEquipment().getItemInOffHand(), cursor)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilar(ItemStack item, ItemStack cursor) {
        return item == null ? cursor == null : item.isSimilar(cursor);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void monitorInventoryCreative(InventoryCreativeEvent e) {
        Player player;
        if (e.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player && (player = (Player)humanEntity).getGameMode() == GameMode.CREATIVE) {
            PlayerState state = this.getPlayerState(player);
            state.setLastItem(e.getCurrentItem());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.playerStates.remove(e.getPlayer().getUniqueId());
    }

    public NMSUtils getTools() {
        return this.tools;
    }

    private class PlayerState {
        private ItemStack lastItem;

        public PlayerState(Main main) {
        }

        public ItemStack getLastItem() {
            return this.lastItem == null ? EMPTY_CURSOR : this.lastItem;
        }

        public void setLastItem(ItemStack lastItem) {
            this.lastItem = lastItem;
        }
    }
}

