/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11;

import de.cubeside.itemcontrol.libs.nmsutils.BiomeUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.biome.CustomBiome;
import de.cubeside.itemcontrol.libs.nmsutils.biome.Precipitation;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.NMSUtilsImpl;
import de.cubeside.itemcontrol.libs.nmsutils.util.ReobfHelper;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class BiomeUtilsImpl
implements BiomeUtils {
    private final NMSUtilsImpl nmsUtils;
    private static final Field FIELD_MAPPED_REGISTRY_FROZEN = ReobfHelper.getFieldByMojangName(MappedRegistry.class, "frozen");
    private static final Field FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS = ReobfHelper.getFieldByMojangName(MappedRegistry.class, "unregisteredIntrusiveHolders");
    private static final Field FIELD_MAPPED_HOLDER_REFERENCE_TAGS = ReobfHelper.getFieldByMojangName(Holder.Reference.class, "tags");

    public BiomeUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public Biome registerBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        Server server = this.nmsUtils.getPlugin().getServer();
        CraftServer craftserver = (CraftServer)server;
        DedicatedServer dedicatedserver = craftserver.getServer();
        ResourceKey newKey = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getKey()));
        ResourceKey oldKey = Biomes.FOREST;
        WritableRegistry registrywritable = (WritableRegistry)dedicatedserver.registryAccess().lookupOrThrow(Registries.BIOME);
        try {
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, false);
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        net.minecraft.world.level.biome.Biome forestbiome = (net.minecraft.world.level.biome.Biome)registrywritable.getValue(oldKey);
        Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
        builder.downfall(downfall);
        builder.temperature(temperature);
        boolean mojangPrecipitation = false;
        if (precipitation == Precipitation.RAIN) {
            mojangPrecipitation = true;
        } else if (precipitation == Precipitation.SNOW) {
            mojangPrecipitation = true;
        }
        builder.hasPrecipitation(mojangPrecipitation);
        builder.mobSpawnSettings(forestbiome.getMobSettings());
        builder.generationSettings(forestbiome.getGenerationSettings());
        builder.temperatureAdjustment(Biome.TemperatureModifier.NONE);
        BiomeSpecialEffects.Builder effects = new BiomeSpecialEffects.Builder();
        effects.waterColor(waterColor == null ? forestbiome.getSpecialEffects().waterColor() : waterColor.intValue());
        if (foliageColor != null) {
            effects.foliageColorOverride(foliageColor.intValue());
        }
        if (grassColor != null) {
            effects.grassColorOverride(grassColor.intValue());
        }
        BiomeSpecialEffects.GrassColorModifier nativeGrassColorModifier = switch (grassColorModifier) {
            case BiomeUtils.GrassColorModifier.DARK_FOREST -> BiomeSpecialEffects.GrassColorModifier.DARK_FOREST;
            case BiomeUtils.GrassColorModifier.SWAMP -> BiomeSpecialEffects.GrassColorModifier.SWAMP;
            default -> BiomeSpecialEffects.GrassColorModifier.NONE;
        };
        effects.grassColorModifier(nativeGrassColorModifier);
        builder.specialEffects(effects.build());
        EnvironmentAttributeMap.Builder attributes = EnvironmentAttributeMap.builder();
        attributes.putAll(forestbiome.getAttributes());
        if (fogColor != null) {
            attributes.set(EnvironmentAttributes.FOG_COLOR, (Object)fogColor);
        }
        if (waterFogColor != null) {
            attributes.set(EnvironmentAttributes.WATER_FOG_COLOR, (Object)waterFogColor);
        }
        if (skyColor != null) {
            attributes.set(EnvironmentAttributes.SKY_COLOR, (Object)skyColor);
        }
        builder.putAttributes(attributes.build());
        net.minecraft.world.level.biome.Biome newbiome = builder.build();
        registrywritable.createIntrusiveHolder((Object)newbiome);
        Holder.Reference biomeHolder = registrywritable.register(newKey, (Object)newbiome, RegistrationInfo.BUILT_IN);
        try {
            FIELD_MAPPED_HOLDER_REFERENCE_TAGS.set(biomeHolder, Set.of());
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, null);
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return (Biome)RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME).get(id);
    }

    @Override
    public CustomBiome registerCustomBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        this.registerBiome(id, downfall, temperature, precipitation, fogColor, waterColor, waterFogColor, skyColor, foliageColor, grassColor, grassColorModifier);
        return null;
    }

    @Override
    public Collection<? extends CustomBiome> getAllCustomBiomes() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public CustomBiome getCustomBiomeAt(Location location) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public CustomBiome getCustomBiome(NamespacedKey id) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public BiomeProvider getVanillaOverworldBiomeProvider(long seed) {
        RandomState randomState;
        final LevelStem stem = (LevelStem)MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.LEVEL_STEM).getValue(LevelStem.OVERWORLD);
        ChunkGenerator chunkGenerator = stem.generator();
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            randomState = RandomState.create((NoiseGeneratorSettings)((NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value()), (HolderGetter)MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.NOISE), (long)seed);
        } else {
            randomState = RandomState.create((NoiseGeneratorSettings)NoiseGeneratorSettings.dummy(), (HolderGetter)MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.NOISE), (long)seed);
        }
        final List<Biome> possibleBiomes = stem.generator().getBiomeSource().possibleBiomes().stream().map(biome -> CraftBiome.minecraftHolderToBukkit((Holder)biome)).toList();
        return new BiomeProvider(this){

            public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit((Holder)stem.generator().getBiomeSource().getNoiseBiome(x >> 2, y >> 2, z >> 2, randomState.sampler()));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }
}

