/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingFlag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingUtil;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingVisitor;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.adapter.FlatAsRegularMappingVisitor;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.adapter.RegularAsFlatMappingVisitor;

public interface FlatMappingVisitor {
    default public Set<MappingFlag> getFlags() {
        return MappingFlag.NONE;
    }

    default public void reset() {
        throw new UnsupportedOperationException();
    }

    default public boolean visitHeader() throws IOException {
        return true;
    }

    public void visitNamespaces(String var1, List<String> var2) throws IOException;

    default public void visitMetadata(String key, String value) throws IOException {
    }

    default public boolean visitContent() throws IOException {
        return true;
    }

    public boolean visitClass(String var1, String[] var2) throws IOException;

    public void visitClassComment(String var1, String[] var2, String var3) throws IOException;

    public boolean visitField(String var1, String var2, String var3, String[] var4, String[] var5, String[] var6) throws IOException;

    public void visitFieldComment(String var1, String var2, String var3, String[] var4, String[] var5, String[] var6, String var7) throws IOException;

    public boolean visitMethod(String var1, String var2, String var3, String[] var4, String[] var5, String[] var6) throws IOException;

    public void visitMethodComment(String var1, String var2, String var3, String[] var4, String[] var5, String[] var6, String var7) throws IOException;

    public boolean visitMethodArg(String var1, String var2, String var3, int var4, int var5, String var6, String[] var7, String[] var8, String[] var9, String[] var10) throws IOException;

    public void visitMethodArgComment(String var1, String var2, String var3, int var4, int var5, String var6, String[] var7, String[] var8, String[] var9, String[] var10, String var11) throws IOException;

    public boolean visitMethodVar(String var1, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String[] var9, String[] var10, String[] var11) throws IOException;

    public void visitMethodVarComment(String var1, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String[] var9, String[] var10, String[] var11, String var12) throws IOException;

    default public boolean visitEnd() throws IOException {
        return true;
    }

    default public MappingVisitor asMethodVisitor() {
        return new FlatAsRegularMappingVisitor(this);
    }

    public static FlatMappingVisitor fromMethodVisitor(MappingVisitor visitor) {
        return new RegularAsFlatMappingVisitor(visitor);
    }

    default public boolean visitField(String srcClsName, String srcName, String srcDesc, String[] dstNames) throws IOException {
        return this.visitField(srcClsName, srcName, srcDesc, null, dstNames, null);
    }

    default public boolean visitMethod(String srcClsName, String srcName, String srcDesc, String[] dstNames) throws IOException {
        return this.visitMethod(srcClsName, srcName, srcDesc, null, dstNames, null);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String[] dstArgNames) throws IOException {
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcArgName, null, null, null, dstArgNames);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, String srcVarName, String[] dstVarNames) throws IOException {
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, srcVarName, null, null, null, dstVarNames);
    }

    default public boolean visitClass(String srcName, String dstName) throws IOException {
        return this.visitClass(srcName, MappingUtil.toArray(dstName));
    }

    default public void visitClassComment(String srcName, String comment) throws IOException {
        this.visitClassComment(srcName, (String)null, comment);
    }

    default public void visitClassComment(String srcName, String dstName, String comment) throws IOException {
        this.visitClassComment(srcName, MappingUtil.toArray(dstName), comment);
    }

    default public boolean visitField(String srcClsName, String srcName, String srcDesc, String dstName) throws IOException {
        return this.visitField(srcClsName, srcName, srcDesc, null, dstName, null);
    }

    default public boolean visitField(String srcClsName, String srcName, String srcDesc, String dstClsName, String dstName, String dstDesc) throws IOException {
        return this.visitField(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc));
    }

    default public void visitFieldComment(String srcClsName, String srcName, String srcDesc, String comment) throws IOException {
        this.visitFieldComment(srcClsName, srcName, srcDesc, (String)null, null, null, comment);
    }

    default public void visitFieldComment(String srcClsName, String srcName, String srcDesc, String dstClsName, String dstName, String dstDesc, String comment) throws IOException {
        this.visitFieldComment(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc), comment);
    }

    default public boolean visitMethod(String srcClsName, String srcName, String srcDesc, String dstName) throws IOException {
        return this.visitMethod(srcClsName, srcName, srcDesc, null, dstName, null);
    }

    default public boolean visitMethod(String srcClsName, String srcName, String srcDesc, String dstClsName, String dstName, String dstDesc) throws IOException {
        return this.visitMethod(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc));
    }

    default public void visitMethodComment(String srcClsName, String srcName, String srcDesc, String comment) throws IOException {
        this.visitMethodComment(srcClsName, srcName, srcDesc, (String)null, null, null, comment);
    }

    default public void visitMethodComment(String srcClsName, String srcName, String srcDesc, String dstClsName, String dstName, String dstDesc, String comment) throws IOException {
        this.visitMethodComment(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc), comment);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String dstArgName) throws IOException {
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcArgName, null, null, null, dstArgName);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String dstClsName, String dstMethodName, String dstMethodDesc, String dstArgName) throws IOException {
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcArgName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstArgName));
    }

    default public void visitMethodArgComment(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String comment) throws IOException {
        this.visitMethodArgComment(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcArgName, (String)null, null, null, null, comment);
    }

    default public void visitMethodArgComment(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String dstClsName, String dstMethodName, String dstMethodDesc, String dstArgName, String comment) throws IOException {
        this.visitMethodArgComment(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcArgName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstArgName), comment);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, String srcVarName, String dstVarName) throws IOException {
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, srcVarName, null, null, null, dstVarName);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, String srcVarName, String dstClsName, String dstMethodName, String dstMethodDesc, String dstVarName) throws IOException {
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, srcVarName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstVarName));
    }

    default public void visitMethodVarComment(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, String srcVarName, String comment) throws IOException {
        this.visitMethodVarComment(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, srcVarName, (String)null, null, null, null, comment);
    }

    default public void visitMethodVarComment(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, String srcVarName, String dstClsName, String dstMethodName, String dstMethodDesc, String dstVarName, String comment) throws IOException {
        this.visitMethodVarComment(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, srcVarName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstVarName), comment);
    }
}

