/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class LongTag
extends Tag<Long> {
    private final long value;

    public LongTag(long value) {
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.getRawValue();
    }

    public long getRawValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.LONG;
    }

    @Override
    public String toString() {
        return "" + this.getRawValue() + 'l';
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (int)(this.value ^ this.value >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongTag other = (LongTag)obj;
        return this.value == other.value;
    }
}

