/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.util;

import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingReader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingVisitor;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.MappingFormat;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.tree.MappingTree;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.tree.MemoryMappingTree;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;

public enum ReobfHelper {
    INSTANCE;

    public static final String MOJANG_PLUS_YARN_NAMESPACE = "mojang+yarn";
    public static final String SPIGOT_NAMESPACE = "spigot";
    private final Map<String, ClassMapping> mappingsByObfName;
    private final Map<String, ClassMapping> mappingsByMojangName;
    static final Map<String, ClassMapping> mappings;

    private ReobfHelper() {
        Set<ClassMapping> maps = ReobfHelper.loadMappingsIfPresent();
        if (maps != null) {
            this.mappingsByObfName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::obfName, map -> map));
            this.mappingsByMojangName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::mojangName, map -> map));
        } else {
            this.mappingsByObfName = null;
            this.mappingsByMojangName = null;
        }
    }

    public Map<String, ClassMapping> mappingsByObfName() {
        return this.mappingsByObfName;
    }

    public Map<String, ClassMapping> mappingsByMojangName() {
        return this.mappingsByMojangName;
    }

    public String reobfClassName(String fullyQualifiedMojangName) {
        if (this.mappingsByMojangName == null) {
            return fullyQualifiedMojangName;
        }
        ClassMapping map = this.mappingsByMojangName.get(fullyQualifiedMojangName);
        if (map == null) {
            return fullyQualifiedMojangName;
        }
        return map.obfName();
    }

    public String deobfClassName(String fullyQualifiedObfName) {
        if (this.mappingsByObfName == null) {
            return fullyQualifiedObfName;
        }
        ClassMapping map = this.mappingsByObfName.get(fullyQualifiedObfName);
        if (map == null) {
            return fullyQualifiedObfName;
        }
        return map.mojangName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<ClassMapping> loadMappingsIfPresent() {
        if (!Bukkit.getServer().getClass().getName().contains("craftbukkit.v")) {
            return null;
        }
        try (InputStream mappingsInputStream = Bukkit.class.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");){
            MappingFormat format;
            if (mappingsInputStream == null) {
                Set<ClassMapping> set2 = null;
                return set2;
            }
            MemoryMappingTree tree = new MemoryMappingTree();
            try {
                format = MappingFormat.valueOf("TINY_2_FILE");
            }
            catch (IllegalArgumentException e) {
                format = MappingFormat.valueOf("TINY_2");
            }
            MappingReader.read(new InputStreamReader(mappingsInputStream, StandardCharsets.UTF_8), format, (MappingVisitor)tree);
            HashSet<ClassMapping> classes = new HashSet<ClassMapping>();
            StringPool pool = new StringPool();
            for (MappingTree.ClassMapping classMapping : tree.getClasses()) {
                HashMap<String, String> methods = new HashMap<String, String>();
                HashMap<String, String> fields = new HashMap<String, String>();
                for (MappingTree.MethodMapping methodMapping : classMapping.getMethods()) {
                    methods.put(pool.string(ReobfHelper.methodOrFieldKey(methodMapping.getName(MOJANG_PLUS_YARN_NAMESPACE), methodMapping.getDesc(MOJANG_PLUS_YARN_NAMESPACE))), pool.string(methodMapping.getName(SPIGOT_NAMESPACE)));
                }
                for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                    fields.put(pool.string(fieldMapping.getName(MOJANG_PLUS_YARN_NAMESPACE)), pool.string(fieldMapping.getName(SPIGOT_NAMESPACE)));
                }
                ClassMapping map = new ClassMapping(classMapping.getName(SPIGOT_NAMESPACE).replace('/', '.'), classMapping.getName(MOJANG_PLUS_YARN_NAMESPACE).replace('/', '.'), Map.copyOf(methods), Map.copyOf(fields));
                classes.add(map);
            }
            Set set = Set.copyOf(classes);
            return set;
        }
        catch (Error | Exception ex) {
            System.err.println("Failed to load mappings for stacktrace deobfuscation.");
            System.err.println(ex.toString());
            ex.printStackTrace();
            return null;
        }
    }

    public static String methodOrFieldKey(String obfName, String obfDescriptor) {
        return obfName + obfDescriptor;
    }

    public static String getObfuscatedFieldName(Class<?> clazz, String field) {
        String fieldName;
        ClassMapping classMapping;
        if (mappings != null && (classMapping = mappings.get(clazz.getName())) != null && (fieldName = classMapping.fieldsByMojang().get(field)) != null) {
            return fieldName;
        }
        return field;
    }

    public static Field getFieldByMojangName(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(ReobfHelper.getObfuscatedFieldName(clazz, fieldName));
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mappings = INSTANCE.mappingsByObfName();
    }

    public record ClassMapping(String obfName, String mojangName, Map<String, String> methodsByMojang, Map<String, String> fieldsByMojang) {
    }

    private static final class StringPool {
        private final Map<String, String> pool = new HashMap<String, String>();

        private StringPool() {
        }

        public String string(String string) {
            return this.pool.computeIfAbsent(string, Function.identity());
        }
    }
}

