/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_9;

import de.cubeside.itemcontrol.libs.nmsutils.BlockUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_9.NMSUtilsImpl;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.Vault;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class BlockUtilsImpl
implements BlockUtils {
    private final NMSUtilsImpl nmsUtils;

    public BlockUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public boolean useBlock(org.bukkit.block.Block block, Player player) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        MovingObjectPositionBlock blockHitResult = new MovingObjectPositionBlock(craftBlock.getPosition().b(), EnumDirection.b, craftBlock.getPosition(), false);
        return craftBlock.getNMS().a((World)world.getHandle(), (EntityHuman)((CraftPlayer)player).getHandle(), blockHitResult).a();
    }

    @Override
    public Set<UUID> getVaultRewardedPlayers(org.bukkit.block.Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof Vault)) {
            throw new IllegalArgumentException("This block is not a vault");
        }
        Vault vault = (Vault)blockState;
        return new HashSet<UUID>(vault.getRewardedPlayers());
    }

    @Override
    public void setTrialSpawnerCooldown(org.bukkit.block.Block block, int ticks) {
        BlockData blockData;
        TrialSpawnerBlockEntity trialSpawnerBlock;
        CraftWorld world;
        block3: {
            block2: {
                CraftBlock craftBlock = (CraftBlock)block;
                world = (CraftWorld)block.getWorld();
                TileEntity blockEntity = world.getHandle().c_(craftBlock.getPosition());
                if (!(blockEntity instanceof TrialSpawnerBlockEntity)) break block2;
                trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
                blockData = block.getBlockData();
                if (blockData instanceof TrialSpawner) break block3;
            }
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawner spawnerData = (TrialSpawner)blockData;
        trialSpawnerBlock.a.h().b();
        trialSpawnerBlock.a.h().c = world.getHandle().ag() + (long)ticks;
        spawnerData.setTrialSpawnerState(TrialSpawner.State.COOLDOWN);
        block.setBlockData((BlockData)spawnerData);
    }

    @Override
    public void setTrialSpawnerConfig(org.bukkit.block.Block block, NamespacedKey key) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        TileEntity blockEntity = world.getHandle().c_(craftBlock.getPosition());
        if (!(blockEntity instanceof TrialSpawnerBlockEntity)) {
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawnerBlockEntity trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
        IRegistry trialSpawnerConfigRegistry = (IRegistry)MinecraftServer.getServer().bg().a(Registries.bq).get();
        MinecraftKey normal = MinecraftKey.a((String)key.namespace(), (String)(key.value() + "/normal"));
        MinecraftKey ominous = MinecraftKey.a((String)key.namespace(), (String)(key.value() + "/ominous"));
        Optional normalConfig = trialSpawnerConfigRegistry.c(normal);
        Optional ominousConfig = trialSpawnerConfigRegistry.c(ominous);
        if (normalConfig.isEmpty() || ominousConfig.isEmpty()) {
            throw new IllegalArgumentException("Config does not exist: " + String.valueOf(key));
        }
        trialSpawnerBlock.a.i = trialSpawnerBlock.a.i.overrideConfigs((Holder)normalConfig.get(), (Holder)ominousConfig.get());
    }

    @Override
    public Set<NamespacedKey> getTrialSpawnerConfigs() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        IRegistry trialSpawnerConfigRegistry = (IRegistry)MinecraftServer.getServer().bg().a(Registries.bq).get();
        for (MinecraftKey loc : trialSpawnerConfigRegistry.i()) {
            if (!loc.a().endsWith("/normal")) continue;
            String path = loc.a().substring(0, loc.a().length() - 7);
            result.add(new NamespacedKey(loc.b(), path));
        }
        return result;
    }

    @Override
    public int getNetworkBlockDataId(BlockData block) {
        return Block.j((IBlockData)((CraftBlockData)block).getState());
    }
}

