/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.BaseCheckName;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckInstrument
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:instrument");
    private boolean allowCustom;
    private boolean allowCustomTextFormating;
    private int allowCustomNameMaxLength;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allowCustom = ConfigUtil.getOrCreate(data, "allow_custom", true);
        this.allowCustomTextFormating = ConfigUtil.getOrCreate(data, "allow_custom_text_formating", false);
        this.allowCustomNameMaxLength = ConfigUtil.getOrCreate(data, "allow_custom_name_max_length", 4000);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        if (!this.allowCustom && itemComponentsTag.getString(key) == null) {
            itemComponentsTag.remove(key);
            changed = true;
        } else {
            CompoundTag compound = itemComponentsTag.getCompound(key);
            if (compound != null && BaseCheckName.enforce(compound, "description", true, this.allowCustomTextFormating, this.allowCustomNameMaxLength, group.getMaxComponentExpansions())) {
                changed = true;
            }
        }
        return changed;
    }
}

