/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.v1_18_R2;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.itemcontrol.libs.nmsutils.EntityUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.util.ReobfHelper;
import de.cubeside.itemcontrol.libs.nmsutils.v1_18_R2.NMSUtilsImpl;
import de.cubeside.itemcontrol.libs.nmsutils.v1_18_R2.PathfinderGoalLimitedRandomStrollLand;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftBat;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVex;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final Field FIELD_BAT_TARGET = ReobfHelper.getFieldByMojangName(EntityBat.class, "targetPosition");
    private static final Field FIELD_ENTITY_TRACKER = ReobfHelper.getFieldByMojangName(net.minecraft.world.entity.Entity.class, "tracker");
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    @Override
    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            EntityInsentient h = ((CraftMob)mob).getHandle();
            h.bQ.a(1, (PathfinderGoal)new PathfinderGoalFloat(h));
        }
    }

    @Override
    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        h.bQ.a(7, (PathfinderGoal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    @Override
    public void removeGoalLimitedStrollLand(Creature mob) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        for (PathfinderGoalWrapped wrappedGoal : h.bQ.c()) {
            PathfinderGoal pathfinderGoal = wrappedGoal.k();
            if (!(pathfinderGoal instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)pathfinderGoal;
            wrappedGoal.d();
            h.bQ.a((PathfinderGoal)goal);
            break;
        }
    }

    @Override
    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fF();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    @Override
    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    @Override
    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fG();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    @Override
    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    @Override
    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        try {
            PlayerChunkMap.EntityTracker ete = (PlayerChunkMap.EntityTracker)FIELD_ENTITY_TRACKER.get(handle);
            if (ete != null) {
                PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(handle);
                ete.f.stream().forEach(viewer -> viewer.a((Packet)positionPacket));
            }
        }
        catch (ReflectiveOperationException e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    @Override
    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.a(EnumMoveType.a, new Vec3D(x, y, z));
    }

    @Override
    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    @Override
    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aZ = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    @Override
    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.ce();
    }

    @Override
    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.o(yaw);
    }

    @Override
    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dn();
    }

    @Override
    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.p(pitch);
    }

    @Override
    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.do();
    }

    @Override
    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                FIELD_BAT_TARGET.set(((CraftBat)entity).getHandle(), new BlockPosition(target.getX(), target.getY(), target.getZ()));
            }
            catch (ReflectiveOperationException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            EntityVex entityVex = ((CraftVex)entity).getHandle();
            entityVex.A().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.G() == null) {
                entityVex.z().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().D().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob");
        }
    }

    @Override
    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            mob.t(left);
        }
    }

    @Override
    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            return mob.ft();
        }
        return false;
    }

    @Override
    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.bU();
    }

    @Override
    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    @Override
    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.Q;
    }

    @Override
    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.Q = noClip;
    }

    @Override
    public boolean areChunkEntitiesLoaded(Chunk c2) {
        return ((CraftWorld)c2.getWorld()).getHandle().c(ChunkCoordIntPair.a((int)c2.getX(), (int)c2.getZ()));
    }

    @Override
    public void loadChunkEntities(Chunk c2) {
        int x = c2.getX();
        int z = c2.getZ();
        World world = c2.getWorld();
        if (!world.isChunkLoaded(x, z)) {
            world.getChunkAt(x, z);
        }
        if (this.areChunkEntitiesLoaded(c2)) {
            return;
        }
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        serverLevel.O.a(new ChunkCoordIntPair(x, z), Visibility.b);
        if (!this.areChunkEntitiesLoaded(c2)) {
            serverLevel.n().c(() -> {
                if (this.areChunkEntitiesLoaded(c2)) {
                    return true;
                }
                serverLevel.O.a();
                return this.areChunkEntitiesLoaded(c2);
            });
        }
    }

    @Override
    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    @Override
    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(EntityPose.values()[pose.ordinal()]);
    }

    @Override
    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        EntityWolf nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    @Override
    public void setAggressive(Mob entity, boolean aggressive) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.u(aggressive);
    }

    @Override
    public boolean isAggressive(Mob entity) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fu();
    }

    @Override
    public boolean isCelebrating(Raider entity) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.fQ();
    }

    @Override
    public void setCelebrating(Raider entity, boolean celebrating) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.z(celebrating);
    }

    @Override
    public void setSwellDir(Creeper creeper, int swellDir) {
        EntityCreeper mcCreeper = ((CraftCreeper)creeper).getHandle();
        mcCreeper.a(swellDir);
    }
}

