/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.TranslationRegistry;

public final class ComponentExpansionLimiter {
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private ComponentExpansionLimiter() {
    }

    public static boolean checkExpansions(BaseComponent component, long maxExpansions) {
        try {
            ComponentExpansionLimiter.checkExpansionsInternal(component, maxExpansions);
            return true;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            return false;
        }
    }

    private static long checkExpansionsInternal(BaseComponent component, long maxExpansions) throws IllegalArgumentException {
        List extra;
        long expansions = 0L;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            expansions += ComponentExpansionLimiter.getTranslationExpansions(translatable, maxExpansions);
        }
        if ((extra = component.getExtra()) != null) {
            for (BaseComponent extraComponent : extra) {
                expansions += ComponentExpansionLimiter.checkExpansionsInternal(extraComponent, maxExpansions);
            }
        }
        if (expansions > maxExpansions) {
            throw new IllegalArgumentException("Too many component expansions!");
        }
        return expansions;
    }

    private static long getTranslationExpansions(TranslatableComponent component, long maxExpansions) throws IllegalArgumentException {
        HashMap<BaseComponent, Integer> expansionCounts = new HashMap<BaseComponent, Integer>();
        String trans = TranslationRegistry.INSTANCE.translate(component.getTranslate());
        if (trans.equals(component.getTranslate()) && component.getFallback() != null) {
            trans = component.getFallback();
        }
        Matcher matcher = TRANSLATION_PATTERN.matcher(trans);
        int position = 0;
        int i = 0;
        while (matcher.find(position)) {
            position = matcher.end();
            String formatCode = matcher.group(2);
            switch (formatCode.charAt(0)) {
                case 'd': 
                case 's': {
                    String withIndex = matcher.group(1);
                    BaseComponent withComponent = (BaseComponent)component.getWith().get(withIndex != null ? Integer.parseInt(withIndex) - 1 : i++);
                    expansionCounts.put(withComponent, expansionCounts.computeIfAbsent(withComponent, c -> 0) + 1);
                }
            }
        }
        long expansions = 0L;
        for (Map.Entry e : expansionCounts.entrySet()) {
            expansions += (ComponentExpansionLimiter.checkExpansionsInternal((BaseComponent)e.getKey(), maxExpansions) + 1L) * (long)((Integer)e.getValue()).intValue();
        }
        return expansions;
    }
}

