/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.BaseCheckName;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckPotionContents
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:potion_contents");
    private boolean allow;
    private boolean customColor;
    private boolean customEffects;
    private boolean customName;
    private boolean customNameAllowFormating;
    private int customNameMaxLength;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", true);
        this.customColor = ConfigUtil.getOrCreate(data, "custom_color", false);
        this.customEffects = ConfigUtil.getOrCreate(data, "custom_effects", false);
        this.customName = ConfigUtil.getOrCreate(data, "custom_name", false);
        this.customNameAllowFormating = ConfigUtil.getOrCreate(data, "custom_name_allow_formating", false);
        this.customNameMaxLength = ConfigUtil.getOrCreate(data, "custom_name_max_length", 4000);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        CompoundTag compound = itemComponentsTag.getCompound(key);
        if (!this.allow || compound == null && itemComponentsTag.getString(key) == null) {
            itemComponentsTag.remove(key);
            changed = true;
        } else if (compound != null) {
            if (!this.customColor && compound.containsKey("custom_color")) {
                compound.remove("custom_color");
                changed = true;
            }
            if (!this.customEffects && compound.containsKey("custom_effects")) {
                compound.remove("custom_effects");
                changed = true;
            }
            if (BaseCheckName.enforce(compound, "custom_name", this.customName, this.customNameAllowFormating, this.customNameMaxLength)) {
                changed = true;
            }
        }
        return changed;
    }
}

